/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.model;

import es.uvigo.darwin.prottest.model.state.ModelEmptyLkState;
import es.uvigo.darwin.prottest.model.state.ModelFilledLkState;
import es.uvigo.darwin.prottest.model.state.ModelLkState;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;
import es.uvigo.darwin.prottest.util.printer.ProtTestFormattedOutput;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import pal.alignment.Alignment;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public abstract class Model
implements Serializable {
    private static final long serialVersionUID = 20090804L;
    public static final int DISTRIBUTION_UNIFORM = 0;
    public static final int DISTRIBUTION_INVARIABLE = 1;
    public static final int DISTRIBUTION_GAMMA = 2;
    public static final int DISTRIBUTION_GAMMA_INV = 3;
    static final int FREQ_DISTRIBUTION_UNIFORM = 1;
    static final int FREQ_DISTRIBUTION_EMPIRICAL = 2;
    static final int FREQ_DISTRIBUTION_MAXIMUM_LIKELIHOOD = 3;
    static final int FREQ_DISTRIBUTION_OTHER = 4;
    public static final String PROP_PLUS_F = "plusF";
    private String matrix;
    private int distribution;
    private boolean plusF;
    protected int frequenciesDistribution;
    private int alignment;
    private int numberOfSequences;
    private Tree tree;
    private int numOfTransCategories;
    private ModelLkState lkState;
    private String[] commandLine;

    public double getLk() {
        return this.lkState.getLk();
    }

    public boolean isComputed() {
        return this.lkState instanceof ModelFilledLkState;
    }

    public void setLk(double lk) {
        this.lkState = this.lkState.setLk(lk);
    }

    public double getAlpha() {
        return this.lkState.getAlpha();
    }

    public void setAlpha(double alpha) {
        this.lkState = this.lkState.setAlpha(alpha);
    }

    public double getInv() {
        return this.lkState.getInv();
    }

    public void setInv(double inv) {
        this.lkState = this.lkState.setInv(inv);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        if (this.alignment != 0 && this.alignment != alignment.toString().hashCode()) {
            throw new ProtTestInternalException("cannot set a different alignment");
        }
        this.alignment = alignment.toString().hashCode();
        this.numberOfSequences = alignment.getSequenceCount();
    }

    public boolean checkAlignment(Alignment alignment) {
        if (alignment == null) {
            return false;
        }
        return this.alignment == alignment.toString().hashCode() && this.numberOfSequences == alignment.getSequenceCount();
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public String[] getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String[] commandLine) {
        this.commandLine = commandLine;
    }

    public int getNumberOfTransitionCategories() {
        return this.numOfTransCategories;
    }

    public Model(String matrix, int distribution, boolean plusF, Alignment alignment, Tree tree, int ncat) {
        if (distribution < 0 || distribution > 3) {
            throw new ProtTestInternalException("Distribution not supported " + distribution);
        }
        if (alignment == null) {
            throw new ProtTestInternalException("Null alignment");
        }
        this.matrix = matrix;
        this.distribution = distribution;
        this.plusF = plusF;
        this.alignment = alignment.toString().hashCode();
        this.numberOfSequences = alignment.getSequenceCount();
        this.tree = tree;
        this.lkState = new ModelEmptyLkState();
        switch (distribution) {
            case 0: {
                this.numOfTransCategories = 1;
                break;
            }
            case 1: {
                this.numOfTransCategories = 2;
                break;
            }
            case 2: {
                this.numOfTransCategories = ncat;
                break;
            }
            case 3: {
                this.numOfTransCategories = ncat;
            }
        }
    }

    public int getDistributionParameters() {
        int value = -1;
        switch (this.distribution) {
            case 0: {
                value = 0;
                break;
            }
            case 1: {
                value = 1;
                break;
            }
            case 2: {
                value = 1;
                break;
            }
            case 3: {
                value = 2;
            }
        }
        return value;
    }

    public abstract int getNumberOfModelParameters();

    public String getMatrix() {
        return this.matrix;
    }

    public int getDistribution() {
        return this.distribution;
    }

    public boolean isPlusF() {
        return this.plusF;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.distribution;
        result = 31 * result + (this.matrix == null ? 0 : this.matrix.hashCode());
        result = 31 * result + (this.isPlusF() ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Model other = (Model)obj;
        if (this.distribution != other.distribution) {
            return false;
        }
        if (this.matrix == null ? other.matrix != null : !this.matrix.equals(other.matrix)) {
            return false;
        }
        return this.isPlusF() == other.isPlusF();
    }

    public String toString() {
        return "Model [distribution=" + this.distribution + ", matrix=" + this.matrix + ", plusF=" + this.isPlusF();
    }

    public abstract String getModelName();

    public int getNumBranches() {
        return 2 * this.numberOfSequences - 3;
    }

    public boolean isGamma() {
        return this.distribution == 2 || this.distribution == 3;
    }

    public boolean isInv() {
        return this.distribution == 1 || this.distribution == 3;
    }

    public void printReport() {
        this.println("Model................................ : " + this.getModelName());
        this.print("  Number of parameters............... : " + this.getNumberOfModelParameters());
        this.println(" (" + (this.getNumberOfModelParameters() - this.getNumBranches()) + " + " + this.getNumBranches() + " branch length estimates)");
        if (this.isComputed()) {
            if (this.isGamma()) {
                this.println("    gamma shape (" + this.getNumberOfTransitionCategories() + " rate categories).. = " + this.getAlpha());
            }
            if (this.isInv()) {
                this.println("    proportion of invariable sites... = " + this.getInv());
            }
            if (this.isPlusF()) {
                this.println("    aminoacid frequencies............ = observed (see above)");
            }
            this.print(" -lnL................................ = " + ProtTestFormattedOutput.getDecimalString(-1.0 * this.getLk(), 2));
            this.println("");
            this.verboseln("The tree:");
            this.verboseln("---------");
            StringWriter ascciiSw = new StringWriter();
            TreeUtils.report((Tree)this.getTree(), (PrintWriter)new PrintWriter(ascciiSw));
            ascciiSw.flush();
            this.verboseln(ascciiSw.toString());
            StringWriter newickSw = new StringWriter();
            this.verboseln("---------");
            TreeUtils.printNH((Tree)this.getTree(), (PrintWriter)new PrintWriter(newickSw));
            newickSw.flush();
            this.verboseln(newickSw.toString());
            this.verboseln("");
        }
        ProtTestLogger.flush(Model.class);
    }

    private void print(String message) {
        ProtTestLogger.info(message, Model.class);
    }

    private void println(String message) {
        ProtTestLogger.infoln(message, Model.class);
    }

    private void verbose(String message) {
        ProtTestLogger.finer(message, Model.class);
    }

    private void verboseln(String message) {
        ProtTestLogger.finerln(message, Model.class);
    }
}

