/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.model;

import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.factory.ProtTestFactory;
import pal.alignment.Alignment;
import pal.tree.Tree;

public class AminoAcidModel
extends Model {
    private static final long serialVersionUID = -8634618735564880783L;

    public AminoAcidModel(String matrix, int distribution, boolean plusF, Alignment alignment, Tree tree, int ncat) {
        super(matrix, distribution, plusF, alignment, tree, ncat);
        this.frequenciesDistribution = this.isPlusF() ? 2 : 4;
    }

    @Override
    public int getNumberOfModelParameters() {
        int numModelParameters = this.getNumBranches() + this.getDistributionParameters();
        if (this.isPlusF()) {
            numModelParameters += 19;
        }
        return numModelParameters;
    }

    @Override
    public String getModelName() {
        String matrixName = ProtTestFactory.getInstance().getApplicationGlobals().getModelName(this.getMatrix(), this.frequenciesDistribution);
        StringBuffer modelName = new StringBuffer(matrixName);
        if (this.getDistribution() == 1) {
            modelName.append("+I");
        } else if (this.getDistribution() == 2) {
            modelName.append("+G");
        } else if (this.getDistribution() == 3) {
            modelName.append("+I+G");
        }
        if (this.isPlusF()) {
            modelName.append("+F");
        }
        return modelName.toString();
    }
}

