/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.global.options;

import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import java.io.Serializable;
import java.util.List;

public class SerializableApplicationOptions
implements Serializable {
    private static final long serialVersionUID = 7758895101915536602L;
    protected int alignment;
    protected int tree;
    public int numberOfCategories;
    public int strategyMode;
    private List<String> matrices;
    private List<Integer> distributions;
    private boolean plusF;

    public int getAlignment() {
        return this.alignment;
    }

    public int getTree() {
        return this.tree;
    }

    public int getNumberOfCategories() {
        return this.numberOfCategories;
    }

    public int getStrategyMode() {
        return this.strategyMode;
    }

    public List<String> getMatrices() {
        return this.matrices;
    }

    public List<Integer> getDistributions() {
        return this.distributions;
    }

    public boolean isPlusF() {
        return this.plusF;
    }

    public SerializableApplicationOptions(ApplicationOptions options) {
        this.alignment = options.getAlignment().toString().hashCode();
        if (options.getTree() != null) {
            this.tree = options.getTree().toString().hashCode();
        }
        this.numberOfCategories = options.ncat;
        this.strategyMode = options.strategyMode;
        this.matrices = options.getMatrices();
        this.distributions = options.getDistributions();
        this.plusF = options.isPlusF();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.alignment;
        result = 31 * result + (this.distributions == null ? 0 : ((Object)this.distributions).hashCode());
        result = 31 * result + (this.matrices == null ? 0 : ((Object)this.matrices).hashCode());
        result = 31 * result + this.numberOfCategories;
        result = 31 * result + (this.plusF ? 1231 : 1237);
        result = 31 * result + this.strategyMode;
        result = 31 * result + this.tree;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableApplicationOptions other = (SerializableApplicationOptions)obj;
        if (this.alignment != other.alignment) {
            return false;
        }
        if (this.distributions == null ? other.distributions != null : !((Object)this.distributions).equals(other.distributions)) {
            return false;
        }
        if (this.matrices == null ? other.matrices != null : !((Object)this.matrices).equals(other.matrices)) {
            return false;
        }
        if (this.numberOfCategories != other.numberOfCategories) {
            return false;
        }
        if (this.plusF != other.plusF) {
            return false;
        }
        if (this.strategyMode != other.strategyMode) {
            return false;
        }
        return this.tree == other.tree;
    }

    public String toString() {
        return "SerializableApplicationOptions [alignment=" + this.alignment + ", distributions=" + this.distributions + ", matrices=" + this.matrices + ", numberOfCategories=" + this.numberOfCategories + ", plusF=" + this.plusF + ", strategyMode=" + this.strategyMode + ", tree=" + this.tree + "]";
    }
}

