/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.global.options;

import es.uvigo.darwin.prottest.global.AminoAcidApplicationGlobals;
import es.uvigo.darwin.prottest.util.ProtTestAlignment;
import es.uvigo.darwin.prottest.util.argumentparser.ProtTestArgumentParser;
import es.uvigo.darwin.prottest.util.exception.AlignmentParseException;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.exception.TreeFormatException;
import es.uvigo.darwin.prottest.util.factory.ProtTestFactory;
import es.uvigo.darwin.prottest.util.fileio.AlignmentReader;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;
import es.uvigo.darwin.prottest.util.printer.ProtTestFormattedOutput;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import pal.alignment.Alignment;
import pal.tree.Tree;

public class ApplicationOptions {
    protected boolean debug = false;
    protected int sampleSizeMode = 2;
    protected double sampleSize = 0.0;
    protected String align_file = null;
    protected String tree_file = null;
    protected String log_file = null;
    protected Alignment alignment;
    protected Tree tree;
    public int ncat = 4;
    public int strategyMode = 0;
    private List<String> matrices = new ArrayList<String>();
    private List<Integer> distributions = new ArrayList<Integer>();
    private HashMap<String, Integer> distributionsHash;
    private boolean plusF = false;
    private boolean displayNewickTree = false;
    private boolean displayASCIITree = false;
    private boolean displayConsensusTree = false;
    private double consensusThreshold;
    private boolean compareAll = false;
    public boolean writeLog = true;
    private char sortBy = (char)65;

    public void setNumberOfCategories(int ncat) {
        this.ncat = ncat;
    }

    public boolean isPlusF() {
        return this.plusF;
    }

    public void setPlusF(boolean plusF) {
        this.plusF = plusF;
    }

    public boolean isDisplayNewickTree() {
        return this.displayNewickTree;
    }

    public boolean isDisplayASCIITree() {
        return this.displayASCIITree;
    }

    public boolean isDisplayConsensusTree() {
        return this.displayConsensusTree;
    }

    public double getConsensusThreshold() {
        return this.consensusThreshold;
    }

    public char getSortBy() {
        return this.sortBy;
    }

    public void setAlignmentFilename(String alignFile) {
        this.align_file = alignFile;
    }

    public boolean setAlignment(String alignFile) throws AlignmentParseException, IOException {
        this.align_file = alignFile;
        StringWriter sw = new StringWriter();
        this.setAlignment(AlignmentReader.readAlignment(new PrintWriter(sw), alignFile, this.debug));
        sw.flush();
        ApplicationOptions.println(sw.toString());
        return alignFile != null;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public synchronized void setTree(Tree tree) {
        this.tree = tree;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isAll() {
        return this.compareAll;
    }

    public void setAll(boolean all) {
        this.compareAll = all;
    }

    public String getTreeFile() {
        return this.tree_file;
    }

    public void setTreeFile(String treeFile) throws TreeFormatException, FileNotFoundException, IOException {
        if (treeFile != null) {
            this.tree_file = treeFile;
            StringWriter sw = new StringWriter();
            this.setTree(AlignmentReader.readTree(new PrintWriter(sw), treeFile, this.debug));
            sw.flush();
            ApplicationOptions.println(sw.toString());
        }
    }

    public int getNumberOfMatrices() {
        return this.matrices.size();
    }

    public List<String> getMatrices() {
        ArrayList<String> matricesClone = new ArrayList<String>(this.matrices);
        return matricesClone;
    }

    public void setMatrices(List<String> newMatrices) {
        this.matrices = newMatrices;
    }

    public String getMatrixAt(int pos) {
        return this.matrices.get(pos);
    }

    public boolean existsMatrix(String matrix) {
        return this.matrices.contains(matrix);
    }

    public boolean removeMatrix(String matrix) {
        return this.matrices.remove(matrix);
    }

    public void addMatrix(String matrix) {
        if (!this.matrices.contains(matrix)) {
            this.matrices.add(matrix);
        }
    }

    public List<Integer> getDistributions() {
        ArrayList<Integer> distributionsClone = new ArrayList<Integer>(this.distributions);
        return distributionsClone;
    }

    public void setDistributions(List<Integer> newDistributions) {
        this.distributions = newDistributions;
    }

    public int getNumberOfDistributions() {
        return this.distributions.size();
    }

    public int getDistributionAt(int pos) {
        return this.distributions.get(pos);
    }

    public int getDistribution(String distribution) {
        return this.distributionsHash.get(distribution);
    }

    public boolean existsDistribution(String distribution) {
        return this.distributionsHash.containsKey(distribution);
    }

    public void addDistribution(String distribution) {
        Integer distributionValue = this.distributionsHash.get(distribution);
        if (!this.distributions.contains(distributionValue)) {
            this.distributions.add(distributionValue);
        }
    }

    public boolean removeDistribution(String distribution) {
        Integer distributionValue = this.distributionsHash.get(distribution);
        return this.distributions.remove(distributionValue);
    }

    public int getSampleSizeMode() {
        return this.sampleSizeMode;
    }

    public double getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSizeMode(int sampleSizeMode) {
        this.sampleSizeMode = sampleSizeMode;
    }

    public void setSampleSize(double sampleSize) {
        this.sampleSize = sampleSize;
    }

    public void setStrategyMode(int strategyMode) {
        if (strategyMode == 3 && this.getTreeFile() == null) {
            throw new ProtTestInternalException("User defined topology must be set");
        }
        this.strategyMode = strategyMode;
    }

    public ApplicationOptions() {
        this.initLists();
    }

    public void fillIn(ProtTestArgumentParser arguments) {
        if (arguments.exists("i")) {
            try {
                this.setAlignment(arguments.getValue("i"));
            }
            catch (AlignmentParseException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Required input file argument -i");
        }
        if (arguments.exists("t")) {
            try {
                this.setTreeFile(arguments.getValue("t"));
            }
            catch (FileNotFoundException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        if (arguments.exists("o")) {
            try {
                FileOutputStream fo = new FileOutputStream(arguments.getValue("o"));
                ProtTestLogger.getDefaultLogger().addHandler(fo, Level.INFO);
            }
            catch (FileNotFoundException fnfe) {
                throw new ProtTestInternalException(fnfe.getMessage());
            }
        }
        this.setDebug(arguments.isSet("verbose"));
        this.displayASCIITree = arguments.isSet("t2");
        this.displayNewickTree = arguments.isSet("t1");
        this.displayConsensusTree = arguments.isSet("tc");
        if (arguments.exists("tc")) {
            this.displayConsensusTree = true;
            this.consensusThreshold = Double.parseDouble(arguments.getValue("tc"));
        }
        this.setAll(arguments.isSet("all"));
        if (arguments.exists("S")) {
            if (this.getTreeFile() != null) {
                this.strategyMode = 3;
            } else {
                this.strategyMode = Integer.parseInt(arguments.getValue("S"));
                if (this.strategyMode == 3 && this.getTreeFile() == null) {
                    throw new IllegalArgumentException("User defined topology must be set");
                }
            }
        }
        if (arguments.exists("sort")) {
            this.sortBy = arguments.getValue("sort").charAt(0);
        }
        if (arguments.exists("sample")) {
            this.sampleSizeMode = Integer.parseInt(arguments.getValue("sample"));
        }
        if (arguments.exists("size")) {
            this.sampleSize = Double.parseDouble(arguments.getValue("size"));
        }
        this.setSampleSize(ProtTestAlignment.calculateSampleSize(this.alignment, this.sampleSizeMode, this.sampleSize));
        boolean existsMatrix = false;
        for (String matrix : arguments.getMatrices()) {
            if (arguments.isSet(matrix)) {
                this.addMatrix(matrix);
                existsMatrix = true;
                continue;
            }
            this.removeMatrix(matrix);
        }
        if (!existsMatrix) {
            throw new IllegalArgumentException("You must specify at least one model matrix");
        }
        this.addDistribution("Uniform");
        boolean plusG = false;
        boolean plusIG = false;
        if (arguments.isSet("I")) {
            this.addDistribution("+I");
        }
        if (arguments.exists("G")) {
            this.addDistribution("+G");
            plusG = true;
        }
        if (arguments.exists("IG")) {
            this.addDistribution("+I+G");
            plusIG = true;
        }
        if (plusG || plusIG) {
            try {
                this.setNumberOfCategories(Integer.parseInt(arguments.getValue("ncat")));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid number of categories " + arguments.getValue("G"));
            }
        }
        if (arguments.isSet("F")) {
            this.setPlusF(true);
        }
    }

    private void initLists() {
        this.distributionsHash = new HashMap();
        this.distributionsHash.put("Uniform", new Integer(0));
        this.distributionsHash.put("+I", new Integer(1));
        this.distributionsHash.put("+G", new Integer(2));
        this.distributionsHash.put("+I+G", new Integer(3));
    }

    public static void usage() {
        int i;
        ApplicationOptions.println("-------------------------------------------------------------------------------------------------");
        ApplicationOptions.println("Basic usage: ");
        ApplicationOptions.println(" - Sequential version: ");
        ApplicationOptions.println("        java -jar prottest-2.1.jar -i alignm_file [OPTIONS]");
        ApplicationOptions.println(" - Parallel version: ");
        ApplicationOptions.println("        mpjrun.sh -wdir $PWD/ -np [NUM_PROCS] -jar ModelTest-2.1.jar -i alignm_file [OPTIONS]");
        ApplicationOptions.println("OPTIONS:");
        ApplicationOptions.println(" -i alignment_filename");
        ApplicationOptions.println("            Alignment input file (required)");
        ApplicationOptions.println(" -t tree_filename");
        ApplicationOptions.println("            Tree file       (optional) [default: NJ tree]");
        ApplicationOptions.println(" -o output_filename");
        ApplicationOptions.println("            Output file     (optional) [default: standard output]");
        ApplicationOptions.println(" -all-matrices");
        ApplicationOptions.println("            Compute all available matrices");
        ApplicationOptions.println(" -[matrix]");
        ApplicationOptions.print("            Include matrix (Amino-acid) = ");
        int count = 0;
        List<String> matrices = ProtTestFactory.getInstance().getApplicationGlobals().getSupportedMatrices();
        for (String matrix : matrices) {
            ApplicationOptions.print(matrix + " ");
            if (count == 7) {
                ApplicationOptions.println("");
                ApplicationOptions.print("\t                                  ");
            }
            ++count;
        }
        ApplicationOptions.println("");
        ApplicationOptions.println("                (requires at least one substitution matrix)");
        ApplicationOptions.println(" -I");
        ApplicationOptions.println("            Include models with a proportion of invariable sites");
        ApplicationOptions.println(" -G");
        ApplicationOptions.println("            Include models with rate variation among sites and number of categories");
        ApplicationOptions.println(" -IG");
        ApplicationOptions.println("            include models with both +I and +G properties");
        ApplicationOptions.println(" -all-distributions");
        ApplicationOptions.println("            Include models with rate variation among sites, number of categories and both");
        ApplicationOptions.println(" -ncat number_of_categories");
        ApplicationOptions.println("            Define number of categories for +G and +I+G models [default: 4]");
        ApplicationOptions.println(" -F");
        ApplicationOptions.println("            Include models with empirical frequency estimation ");
        ApplicationOptions.println(" -sort sot_by_value");
        ApplicationOptions.println("            Ordering field\t(optional) [default: A]");
        for (char value : AminoAcidApplicationGlobals.SORTBY_VALUES) {
            ApplicationOptions.println("             \t\t" + value + ": " + AminoAcidApplicationGlobals.SORTBY_NAMES[value - 65]);
        }
        ApplicationOptions.println(" -all");
        ApplicationOptions.println("            Displays a 7-framework comparison table");
        ApplicationOptions.println(" -S optimization_strategy");
        ApplicationOptions.println("            Optimization strategy mode: [default: 0]");
        for (i = 0; i < AminoAcidApplicationGlobals.OPTIMIZE_NAMES.length; ++i) {
            ApplicationOptions.println("             \t\t" + i + ": " + AminoAcidApplicationGlobals.OPTIMIZE_NAMES[i]);
        }
        ApplicationOptions.println(" -sample sample_size_mode");
        ApplicationOptions.println("            Sample size for AICc and BIC corrections [default: 2]");
        for (i = 0; i < AminoAcidApplicationGlobals.SIZE_MODE_NAMES.length; ++i) {
            ApplicationOptions.println("             \t\t" + i + ": " + AminoAcidApplicationGlobals.SIZE_MODE_NAMES[i]);
        }
        ApplicationOptions.println(" -size user_size  \t\t");
        ApplicationOptions.println("            Specified sample size, only for \"-sample 5\"");
        ApplicationOptions.println(" -t1      \t\t\t\t");
        ApplicationOptions.println("            Display best-model's newick tree [default: false]");
        ApplicationOptions.println(" -t2      \t\t\t\t");
        ApplicationOptions.println("            Display best-model's ASCII tree  [default: false]");
        ApplicationOptions.println(" -tc consensus_threshold ");
        ApplicationOptions.println("            Display consensus tree with the specified threshold");
        ApplicationOptions.println(" -threads number_or_threads\t\t\t");
        ApplicationOptions.println("            Number of threads requested to compute (only if MPJ is not used) [default: 1]");
        ApplicationOptions.println(" -verbose");
        ApplicationOptions.println("            Verbose mode [default: false]");
        ApplicationOptions.println("-------------------------------------------------------------------------------------------------");
        ApplicationOptions.println("Example: ");
        ApplicationOptions.println("- Sequential version:");
        ApplicationOptions.println("    java -jar ModelTest-2.1.jar -i alignm_file -t tree_file -S 0 -sample 1 -all-matrices -all-distributions -F > output");
        ApplicationOptions.println("- Parallel version:");
        ApplicationOptions.println("    mpjrun.sh -wdir $PWD/ -np 2 -jar ModelTest-2.1.jar -i alignm_file -t tree_file -S 0 -sample 1 -all-matrices -all-distributions -F");
    }

    public void describeFramework() {
        ApplicationOptions.println("");
        ApplicationOptions.println("************************************************************");
        if (this.sortBy == 'A') {
            ApplicationOptions.println("Akaike Information Chriterion (AIC) framework");
        } else if (this.sortBy == 'C') {
            ApplicationOptions.println("Second-order AIC (AICc) framework");
        } else if (this.sortBy == 'B') {
            ApplicationOptions.println("Bayesian Information Chriterion (BIC) framework");
        } else if (this.sortBy == 'D') {
            ApplicationOptions.println("Maximum Likelihood (-lnL) framework");
        }
        if (this.sortBy != 'A' && this.sortBy != 'D') {
            ApplicationOptions.println("Sample size:  " + AminoAcidApplicationGlobals.SIZE_MODE_NAMES[this.sampleSizeMode]);
            ApplicationOptions.println("           =  " + ProtTestFormattedOutput.getDecimalString(this.sampleSize, 2));
        }
    }

    public void reportModelOptimization() {
        String tmp = "BioNJ";
        if (this.tree_file != null) {
            tmp = this.tree_file;
        }
        ApplicationOptions.println("");
        ApplicationOptions.println("ProtTest options");
        ApplicationOptions.println("----------------");
        ApplicationOptions.println("  Alignment file........... : " + this.align_file);
        ApplicationOptions.println("  Tree..................... : " + tmp);
        ApplicationOptions.println("  StrategyMode............. : " + AminoAcidApplicationGlobals.OPTIMIZE_NAMES[this.strategyMode]);
        ApplicationOptions.println("  Candidate models......... : ");
        ApplicationOptions.print("    Matrices............... : ");
        for (int i = 0; i < this.matrices.size(); ++i) {
            ApplicationOptions.print(this.matrices.get(i) + " ");
        }
        ApplicationOptions.println("");
        ApplicationOptions.print("    Distributions.......... : ");
        for (String dist : this.distributionsHash.keySet()) {
            Integer value = this.distributionsHash.get(dist);
            if (!this.distributions.contains(value)) continue;
            ApplicationOptions.print(dist + " ");
        }
        ApplicationOptions.println("");
        ApplicationOptions.println("    Observed frequencies... : " + this.plusF);
        ApplicationOptions.println("");
    }

    public void reportComplete() {
        this.reportModelOptimization();
        ApplicationOptions.println("  Statistical framework");
        ApplicationOptions.println("    Sort models according to....: " + AminoAcidApplicationGlobals.SORTBY_NAMES[this.getSortBy() - 65]);
        if (this.sampleSizeMode == 5) {
            ApplicationOptions.println("    Sample size.................: " + this.sampleSize);
        } else {
            ApplicationOptions.println("    Sample size.................: " + this.sampleSize + " (not calculated yet)");
        }
        ApplicationOptions.println("      sampleSizeMode............: " + AminoAcidApplicationGlobals.SIZE_MODE_NAMES[this.sampleSizeMode]);
        ApplicationOptions.println("  Other options:");
        ApplicationOptions.println("    Display best tree in ASCII..: " + this.displayASCIITree);
        ApplicationOptions.println("    Display best tree in Newick.: " + this.displayNewickTree);
        ApplicationOptions.println("    Display consensus tree......: " + this.displayConsensusTree);
        if (this.displayConsensusTree) {
            ApplicationOptions.println("    Consensus threshold.........: " + this.consensusThreshold);
        }
        ApplicationOptions.println("    Verbose.....................: " + this.debug);
        ApplicationOptions.println("");
    }

    private static void print(String message) {
        ProtTestLogger.info(message, ApplicationOptions.class);
    }

    private static void println(String message) {
        ProtTestLogger.infoln(message, ApplicationOptions.class);
    }

    private static void verbose(String message) {
        ProtTestLogger.fine(message, ApplicationOptions.class);
    }

    private static void verboseln(String message) {
        ProtTestLogger.fineln(message, ApplicationOptions.class);
    }
}

