/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade.util;

import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.selection.InformationCriterion;
import es.uvigo.darwin.prottest.selection.model.SelectionModel;
import java.util.Collection;

public class SelectionChunk {
    public static final int AIC = 1;
    public static final int BIC = 2;
    public static final int AICC = 3;
    public static final int DT = 4;
    public static final int LNL = 5;
    private InformationCriterion informationCriterion;

    public InformationCriterion getInformationCriterion() {
        return this.informationCriterion;
    }

    public SelectionChunk(InformationCriterion informationCriterion) {
        this.informationCriterion = informationCriterion;
    }

    public boolean existGammaModels() {
        return this.informationCriterion.isExistGammaModels();
    }

    public boolean existInvModels() {
        return this.informationCriterion.isExistInvModels();
    }

    public boolean existGammaInvModels() {
        return this.informationCriterion.isExistGammaInvModels();
    }

    public boolean existFModels() {
        return this.informationCriterion.isExistFModels();
    }

    public double getValue(Model model) {
        return this.informationCriterion.get(model).getValue();
    }

    public double getDeltaValue(Model model) {
        return this.informationCriterion.get(model).getDeltaValue();
    }

    public double getWeightValue(Model model) {
        return this.informationCriterion.get(model).getWeightValue();
    }

    public double getOverallAlpha() {
        return this.informationCriterion.getOverallAlpha();
    }

    public double getOverallAlphaInv() {
        return this.informationCriterion.getOverallAlphaInv();
    }

    public double getOverallInv() {
        return this.informationCriterion.getOverallInv();
    }

    public double getOverallInvAlpha() {
        return this.informationCriterion.getOverallInvAlpha();
    }

    public double getAlphaImportance() {
        return this.informationCriterion.getAlphaImportance();
    }

    public double getInvImportance() {
        return this.informationCriterion.getInvImportance();
    }

    public double getAlphaInvImportance() {
        return this.informationCriterion.getAlphaInvImportance();
    }

    public double getFImportance() {
        return this.informationCriterion.getFImportance();
    }

    public Collection<SelectionModel> getConfidenceModels() {
        return this.informationCriterion.getConfidenceModels();
    }
}

