/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade.thread;

import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.util.Hashtable;

public class ThreadPoolSynchronizer {
    private Hashtable<Long, Integer> threadIds;
    private int nextValue;
    private int poolSize;
    private static ThreadPoolSynchronizer instance;

    private ThreadPoolSynchronizer(int poolSize) {
        this.poolSize = poolSize;
        this.threadIds = new Hashtable(poolSize);
        this.nextValue = 0;
    }

    public synchronized int getThreadId(Thread thread) {
        long threadNumber = thread.getId();
        Integer value = this.threadIds.get(threadNumber);
        if (value == null) {
            if (this.nextValue >= this.poolSize) {
                throw new ProtTestInternalException("Thread out of sync on ThreadPool");
            }
            value = this.nextValue++;
            this.threadIds.put(threadNumber, value);
        }
        return value;
    }

    public static void synchronize(int poolSize) {
        instance = new ThreadPoolSynchronizer(poolSize);
    }

    public static synchronized ThreadPoolSynchronizer getInstance() throws ProtTestInternalException {
        if (instance == null) {
            throw new ProtTestInternalException("ThreadPool out of sync");
        }
        return instance;
    }
}

