/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade.strategy;

import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.facade.strategy.DistributionStrategy;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.collection.ParallelModelCollection;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.comparator.ModelWeightComparator;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import mpi.MPI;
import mpi.Request;

public class StaticDistributionStrategy
extends DistributionStrategy {
    public StaticDistributionStrategy(int mpjMe, int mpjSize, ApplicationOptions options) {
        super(mpjMe, mpjSize, options, null);
    }

    @Override
    public Model[] distribute(ModelCollection arrayListModel, ModelWeightComparator comparator) {
        this.itemsPerProc = new int[this.mpjSize];
        this.displs = new int[this.mpjSize];
        this.numberOfModels = arrayListModel.size();
        ParallelModelCollection pmi = new ParallelModelCollection(arrayListModel, this.mpjSize, comparator);
        Request[] requests = new Request[this.mpjSize - 1];
        for (int procToSend = 1; procToSend < this.mpjSize; ++procToSend) {
            SingleModelCollection[] modelsToSend = new SingleModelCollection[]{pmi.getModelCollection(procToSend)};
            this.itemsPerProc[procToSend] = modelsToSend[0].size();
            requests[procToSend - 1] = MPI.COMM_WORLD.Isend((Object)modelsToSend, 0, 1, MPI.OBJECT, procToSend, 2);
        }
        this.modelSet = pmi.getModelCollection(this.mpjMe);
        this.itemsPerProc[0] = this.modelSet.size();
        this.displs[0] = 0;
        for (int i = 1; i < this.mpjSize; ++i) {
            this.displs[i] = this.displs[i - 1] + this.itemsPerProc[i - 1];
        }
        Request.Waitall((Request[])requests);
        this.startTime = System.currentTimeMillis();
        Model[] models = this.compute(this.modelSet);
        this.endTime = System.currentTimeMillis();
        return models;
    }

    @Override
    public void request() {
        this.startTime = System.currentTimeMillis();
        SingleModelCollection[] modelsToReceive = new SingleModelCollection[1];
        Request request = MPI.COMM_WORLD.Irecv((Object)modelsToReceive, 0, 1, MPI.OBJECT, 0, 2);
        request.Wait();
        this.modelSet = modelsToReceive[0];
        this.compute(this.modelSet);
        this.endTime = System.currentTimeMillis();
    }

    private Model[] compute(ModelCollection modelSet) {
        RunEstimator[] runenv = new RunEstimator[modelSet.size()];
        int current = 0;
        for (Model model : modelSet) {
            runenv[current] = this.factory.createRunEstimator(this.options, model);
            runenv[current].addObserver(this);
            if (!runenv[current].optimizeModel()) {
                throw new ProtTestInternalException("Optimization error");
            }
            ++current;
        }
        return this.gather();
    }

    private Model[] gather() {
        Model[] allModels = new Model[this.numberOfModels];
        if (this.mpjSize > 1) {
            MPI.COMM_WORLD.Gatherv((Object)this.modelSet.toArray(new Model[0]), 0, this.modelSet.size(), MPI.OBJECT, (Object)allModels, 0, this.itemsPerProc, this.displs, MPI.OBJECT, 0);
        } else {
            allModels = this.modelSet.toArray(new Model[0]);
        }
        return allModels;
    }
}

