/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade.strategy;

import es.uvigo.darwin.prottest.facade.strategy.HybridDistributionStrategy;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.comparator.ModelWeightComparator;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.util.Collections;
import mpi.MPI;
import mpi.Request;
import mpi.Status;

public class MultipleDistributor
implements Runnable {
    private static final int TAG_SEND_REQUEST = 1;
    private static final int TAG_EXIST_MORE_MODELS = 2;
    private static final int TAG_SEND_MODEL = 3;
    private int mpjMe;
    private int mpjSize;
    private HybridDistributionStrategy caller;
    private ModelCollection modelsToSend;
    private ModelWeightComparator comparator;
    private int[] itemsPerProc;
    private int[] displs;
    private int maxAvailableThreads = 8;

    public int[] getItemsPerProc() {
        return this.itemsPerProc;
    }

    public int[] getDispls() {
        return this.displs;
    }

    public MultipleDistributor(HybridDistributionStrategy caller, ModelCollection modelCollection, ModelWeightComparator comparator, int mpjMe, int mpjSize) {
        this.comparator = comparator;
        this.modelsToSend = modelCollection.clone();
        Collections.sort(this.modelsToSend, comparator);
        this.mpjMe = mpjMe;
        this.mpjSize = mpjSize;
        this.caller = caller;
    }

    @Override
    public void run() {
        this.distribute();
    }

    private void distribute() {
        int i;
        this.itemsPerProc = new int[this.mpjSize];
        Status requestStatus = null;
        this.displs = new int[this.mpjSize];
        int[] freePEs = new int[1];
        boolean sended = true;
        Request modelRequest = null;
        while (!this.modelsToSend.isEmpty()) {
            if (this.caller.rootModelRequest && this.caller.availablePEs > 0) {
                Model rootModel = this.getNextModel(this.caller.availablePEs);
                if (rootModel == null) continue;
                this.caller.rootModel = rootModel;
                this.caller.rootModelRequest = false;
                int n = this.mpjMe;
                this.itemsPerProc[n] = this.itemsPerProc[n] + 1;
                continue;
            }
            if (sended) {
                modelRequest = MPI.COMM_WORLD.Irecv((Object)freePEs, 0, 1, MPI.INT, MPI.ANY_SOURCE, 1);
                sended = false;
            }
            if ((requestStatus = modelRequest.Test()) != null) {
                Request notifySend = MPI.COMM_WORLD.Isend((Object)new boolean[]{true}, 0, 1, MPI.BOOLEAN, requestStatus.source, 2);
                Model[] modelToSend = new Model[1];
                notifySend.Wait();
                modelToSend[0] = this.getNextModel(freePEs[0]);
                Request modelSend = MPI.COMM_WORLD.Isend((Object)modelToSend, 0, 1, MPI.OBJECT, requestStatus.source, 3);
                if (modelToSend[0] != null) {
                    int n = requestStatus.source;
                    this.itemsPerProc[n] = this.itemsPerProc[n] + 1;
                }
                modelSend.Wait();
                sended = true;
                requestStatus = null;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new ProtTestInternalException("Thread interrupted");
            }
        }
        this.displs[0] = 0;
        for (i = 1; i < this.mpjSize; ++i) {
            this.displs[i] = this.displs[i - 1] + this.itemsPerProc[i - 1];
        }
        while (!this.caller.rootModelRequest) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new ProtTestInternalException("Thread interrupted");
            }
        }
        this.caller.rootModel = null;
        this.caller.rootModelRequest = false;
        for (i = 1; i < this.mpjSize; ++i) {
            modelRequest = MPI.COMM_WORLD.Irecv((Object)freePEs, 0, 1, MPI.INT, MPI.ANY_SOURCE, 1);
            requestStatus = modelRequest.Wait();
            Request notifySend = MPI.COMM_WORLD.Isend((Object)new boolean[]{false}, 0, 1, MPI.BOOLEAN, requestStatus.source, 2);
            notifySend.Wait();
        }
    }

    private Model getNextModel(int numPEs) {
        Model nextModel = null;
        for (Model model : this.modelsToSend) {
            if (MultipleDistributor.getPEs(model, this.maxAvailableThreads) > numPEs) continue;
            nextModel = model;
            break;
        }
        this.modelsToSend.remove(nextModel);
        return nextModel;
    }

    public static int getPEs(Model model, int maxAvailableThreads) {
        int numberOfThreads = model.isGamma() ? 4 : (model.isInv() ? 2 : 1);
        return Math.min(maxAvailableThreads, numberOfThreads);
    }
}

