/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade.strategy;

import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.facade.strategy.DistributionStrategy;
import es.uvigo.darwin.prottest.facade.strategy.Distributor;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.checkpoint.CheckPointManager;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.comparator.ModelWeightComparator;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.util.ArrayList;
import mpi.MPI;
import mpi.Request;

public class ImprovedDynamicDistributionStrategy
extends DistributionStrategy {
    private static final int TAG_SEND_REQUEST = 1;
    private static final int TAG_SEND_MODEL = 2;
    boolean rootModelRequest;
    Model rootModel;

    public ImprovedDynamicDistributionStrategy(int mpjMe, int mpjSize, ApplicationOptions options, CheckPointManager cpManager) {
        super(mpjMe, mpjSize, options, cpManager);
        if (mpjSize == 1) {
            throw new ProtTestInternalException("Dynamic Distribution Strategy requires at least 2 processors");
        }
        this.itemsPerProc = new int[mpjSize];
        this.displs = new int[mpjSize];
        this.modelSet = new SingleModelCollection(options.getAlignment());
    }

    @Override
    public Model[] distribute(ModelCollection arrayListModel, ModelWeightComparator comparator) {
        Distributor distributor = new Distributor(this, arrayListModel, comparator, this.mpjMe, this.mpjSize);
        Thread distributorThread = new Thread(distributor);
        distributorThread.start();
        this.numberOfModels = arrayListModel.size();
        this.request();
        this.itemsPerProc = distributor.getItemsPerProc();
        this.displs = distributor.getDispls();
        this.computationDone();
        return arrayListModel.toArray(new Model[0]);
    }

    @Override
    public void request() {
        this.startTime = System.currentTimeMillis();
        ArrayList<RunEstimator> runenvList = new ArrayList<RunEstimator>();
        Model[] lastComputedModel = new Model[1];
        while (true) {
            Model[] modelToReceive = null;
            Model model = null;
            if (this.mpjMe > 0) {
                Request modelRequest = MPI.COMM_WORLD.Isend((Object)lastComputedModel, 0, 1, MPI.OBJECT, 0, 1);
                modelToReceive = new Model[1];
                modelRequest.Wait();
                Request modelReceive = MPI.COMM_WORLD.Irecv((Object)modelToReceive, 0, 1, MPI.OBJECT, 0, 2);
                modelReceive.Wait();
                model = modelToReceive[0];
            } else {
                this.rootModelRequest = true;
                while (this.rootModelRequest) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        throw new ProtTestInternalException("Thread interrupted");
                    }
                }
                model = this.rootModel;
            }
            if (model == null) break;
            this.modelSet.add(model);
            RunEstimator runenv = this.factory.createRunEstimator(this.options, model);
            runenv.addObserver(this);
            if (!runenv.optimizeModel()) {
                throw new ProtTestInternalException("Optimization error");
            }
            runenvList.add(runenv);
            lastComputedModel[0] = runenv.getModel();
        }
        this.endTime = System.currentTimeMillis();
    }
}

