/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade.strategy;

import es.uvigo.darwin.prottest.exe.ParallelModelEstimator;
import es.uvigo.darwin.prottest.facade.strategy.DistributionStrategy;
import es.uvigo.darwin.prottest.facade.strategy.MultipleDistributor;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.observer.ObservableModelUpdater;
import es.uvigo.darwin.prottest.util.checkpoint.CheckPointManager;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.comparator.ModelWeightComparator;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import mpi.MPI;

public class HybridDistributionStrategy
extends DistributionStrategy {
    private static final int TAG_SEND_REQUEST = 1;
    private static final int TAG_EXIST_MORE_MODELS = 2;
    private static final int TAG_SEND_MODEL = 3;
    private int maxPEs;
    int availablePEs;
    boolean rootModelRequest;
    Model rootModel;
    private ParallelModelEstimator pme;
    private Model[] computedModels;
    private MultipleDistributor distributor;

    public HybridDistributionStrategy(int mpjMe, int mpjSize, ApplicationOptions options, CheckPointManager cpManager) {
        this(mpjMe, mpjSize, options, cpManager, Runtime.getRuntime().availableProcessors());
    }

    public HybridDistributionStrategy(int mpjMe, int mpjSize, ApplicationOptions options, CheckPointManager cpManager, int numberOfThreads) {
        super(mpjMe, mpjSize, options, cpManager);
        if (mpjSize == 1) {
            throw new ProtTestInternalException("Dynamic Distribution Strategy requires at least 2 processors");
        }
        this.itemsPerProc = new int[mpjSize];
        this.displs = new int[mpjSize];
        this.modelSet = new SingleModelCollection(options.getAlignment());
        this.availablePEs = this.maxPEs = numberOfThreads;
        this.pme = new ParallelModelEstimator(this.maxPEs, options.getAlignment());
        this.pme.addObserver(this);
    }

    @Override
    public Model[] distribute(ModelCollection arrayListModel, ModelWeightComparator comparator) {
        this.distributor = new MultipleDistributor(this, arrayListModel, comparator, this.mpjMe, this.mpjSize);
        Thread distributorThread = new Thread(this.distributor);
        distributorThread.start();
        this.numberOfModels = arrayListModel.size();
        this.request();
        this.computationDone();
        return this.computedModels;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void request() {
        this.startTime = System.currentTimeMillis();
        block6: while (true) {
            modelToReceive = null;
            model = null;
            if (this.mpjMe > 0) {
                sendMessage = new int[]{this.availablePEs};
                modelRequest = MPI.COMM_WORLD.Isend((Object)sendMessage, 0, 1, MPI.INT, 0, 1);
                modelToReceive = new Model[1];
                notification = new boolean[1];
                modelRequest.Wait();
                notifyRecv = MPI.COMM_WORLD.Irecv((Object)notification, 0, 1, MPI.BOOLEAN, 0, 2);
                notifyRecv.Wait();
                if (!notification[0]) break;
                modelReceive = MPI.COMM_WORLD.Irecv((Object)modelToReceive, 0, 1, MPI.OBJECT, 0, 3);
                modelReceive.Wait();
                model = modelToReceive[0];
            } else {
                this.rootModelRequest = true;
                while (this.rootModelRequest) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        throw new ProtTestInternalException("Thread interrupted");
                    }
                }
                model = this.rootModel;
                if (model == null) break;
            }
            if (model == null) continue;
            this.availablePEs -= MultipleDistributor.getPEs(model, this.maxPEs);
            this.modelSet.add(model);
            runenv = this.factory.createRunEstimator(this.options, model, MultipleDistributor.getPEs(model, this.maxPEs));
            this.pme.execute(runenv);
            while (true) {
                if (this.availablePEs <= 0) ** break;
                continue block6;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new ProtTestInternalException("Thread interrupted");
                }
            }
            break;
        }
        this.endTime = System.currentTimeMillis();
        while (this.pme.hasMoreTasks()) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                throw new ProtTestInternalException("Thread interrupted");
            }
        }
        if (this.mpjMe > 0) {
            this.gather();
        } else {
            this.computedModels = this.gather();
        }
    }

    @Override
    public void update(ObservableModelUpdater o, Model model, ApplicationOptions options) {
        if (options != null && model.isComputed()) {
            this.availablePEs += MultipleDistributor.getPEs(model, this.maxPEs);
        }
        super.update(o, model, options);
    }

    private Model[] gather() {
        Model[] allModels = new Model[this.numberOfModels];
        if (this.distributor != null) {
            this.itemsPerProc = this.distributor.getItemsPerProc();
            this.displs = this.distributor.getDispls();
        }
        MPI.COMM_WORLD.Bcast((Object)this.itemsPerProc, 0, this.mpjSize, MPI.INT, 0);
        MPI.COMM_WORLD.Gatherv((Object)this.modelSet.toArray(new Model[0]), 0, this.modelSet.size(), MPI.OBJECT, (Object)allModels, 0, this.itemsPerProc, this.displs, MPI.OBJECT, 0);
        return allModels;
    }
}

