/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade.strategy;

import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.facade.strategy.DistributionStrategy;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.checkpoint.CheckPointManager;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.comparator.ModelWeightComparator;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.util.ArrayList;
import java.util.Collections;
import mpi.MPI;
import mpi.Request;
import mpi.Status;

public class DynamicDistributionStrategy
extends DistributionStrategy {
    private static final int TAG_SEND_REQUEST = 1;
    private static final int TAG_SEND_MODEL = 2;

    public DynamicDistributionStrategy(int mpjMe, int mpjSize, ApplicationOptions options, CheckPointManager cpManager) {
        super(mpjMe, mpjSize, options, cpManager);
        if (mpjSize == 1) {
            throw new ProtTestInternalException("Dynamic Distribution Strategy requires at least 2 processors");
        }
        this.itemsPerProc = new int[mpjSize];
        this.displs = new int[mpjSize];
        this.modelSet = new SingleModelCollection(options.getAlignment());
    }

    @Override
    public Model[] distribute(ModelCollection arrayListModel, ModelWeightComparator comparator) {
        int i;
        this.numberOfModels = arrayListModel.size();
        Collections.sort(arrayListModel, comparator);
        for (Model model : arrayListModel) {
            Model[] computedModel = new Model[1];
            Request modelRequest = MPI.COMM_WORLD.Irecv((Object)computedModel, 0, 1, MPI.OBJECT, MPI.ANY_SOURCE, 1);
            Model[] modelToSend = new Model[]{model};
            Status requestStatus = modelRequest.Wait();
            if (computedModel[0] != null) {
                int index = arrayListModel.indexOf(computedModel[0]);
                arrayListModel.set(index, computedModel[0]);
                this.setCheckpoint(arrayListModel);
            }
            Request modelSend = MPI.COMM_WORLD.Isend((Object)modelToSend, 0, 1, MPI.OBJECT, requestStatus.source, 2);
            int n = requestStatus.source;
            this.itemsPerProc[n] = this.itemsPerProc[n] + 1;
            modelSend.Wait();
        }
        this.itemsPerProc[0] = this.modelSet.size();
        this.displs[0] = 0;
        for (i = 1; i < this.mpjSize; ++i) {
            this.displs[i] = this.displs[i - 1] + this.itemsPerProc[i - 1];
        }
        for (i = 1; i < this.mpjSize; ++i) {
            Model[] computedModel = new Model[1];
            Request modelRequest = MPI.COMM_WORLD.Irecv((Object)computedModel, 0, 1, MPI.OBJECT, MPI.ANY_SOURCE, 1);
            Model[] modelToSend = new Model[]{null};
            Status requestStatus = modelRequest.Wait();
            if (computedModel[0] != null) {
                int index = arrayListModel.indexOf(computedModel[0]);
                arrayListModel.set(index, computedModel[0]);
                this.setCheckpoint(arrayListModel);
            }
            Request modelSend = MPI.COMM_WORLD.Isend((Object)modelToSend, 0, 1, MPI.OBJECT, requestStatus.source, 2);
            modelSend.Wait();
        }
        this.computationDone();
        return arrayListModel.toArray(new Model[0]);
    }

    @Override
    public void request() {
        this.startTime = System.currentTimeMillis();
        ArrayList<RunEstimator> runenvList = new ArrayList<RunEstimator>();
        Model[] lastComputedModel = new Model[1];
        while (true) {
            Request modelRequest = MPI.COMM_WORLD.Isend((Object)lastComputedModel, 0, 1, MPI.OBJECT, 0, 1);
            Model[] modelToReceive = new Model[1];
            modelRequest.Wait();
            Request modelReceive = MPI.COMM_WORLD.Irecv((Object)modelToReceive, 0, 1, MPI.OBJECT, 0, 2);
            modelReceive.Wait();
            Model model = modelToReceive[0];
            if (model == null) break;
            this.modelSet.add(model);
            RunEstimator runenv = this.factory.createRunEstimator(this.options, model);
            runenv.addObserver(this);
            if (!runenv.optimizeModel()) {
                throw new ProtTestInternalException("Optimization error");
            }
            runenvList.add(runenv);
            lastComputedModel[0] = runenv.getModel();
        }
        this.endTime = System.currentTimeMillis();
    }
}

