/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade.strategy;

import es.uvigo.darwin.prottest.facade.strategy.ImprovedDynamicDistributionStrategy;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.comparator.ModelWeightComparator;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.util.Collections;
import mpi.MPI;
import mpi.Request;
import mpi.Status;

public class Distributor
implements Runnable {
    private static final int TAG_SEND_REQUEST = 1;
    private static final int TAG_SEND_MODEL = 2;
    private int mpjMe;
    private int mpjSize;
    private ImprovedDynamicDistributionStrategy caller;
    private ModelCollection modelCollection;
    private ModelWeightComparator comparator;
    private int[] itemsPerProc;
    private int[] displs;

    public int[] getItemsPerProc() {
        return this.itemsPerProc;
    }

    public int[] getDispls() {
        return this.displs;
    }

    public Distributor(ImprovedDynamicDistributionStrategy caller, ModelCollection modelCollection, ModelWeightComparator comparator, int mpjMe, int mpjSize) {
        this.comparator = comparator;
        this.modelCollection = modelCollection;
        this.mpjMe = mpjMe;
        this.mpjSize = mpjSize;
        this.caller = caller;
    }

    @Override
    public void run() {
        this.distribute(this.modelCollection, this.comparator);
    }

    private void distribute(ModelCollection modelSet, ModelWeightComparator comparator) {
        int i;
        this.itemsPerProc = new int[this.mpjSize];
        this.displs = new int[this.mpjSize];
        Collections.sort(modelSet, comparator);
        for (Model model : modelSet) {
            if (this.caller.rootModelRequest) {
                if (this.caller.rootModel != null) {
                    this.caller.setCheckpoint(modelSet);
                }
                this.caller.rootModel = model;
                this.caller.rootModelRequest = false;
                int n = this.mpjMe;
                this.itemsPerProc[n] = this.itemsPerProc[n] + 1;
                continue;
            }
            Model[] computedModel = new Model[1];
            Request modelRequest = MPI.COMM_WORLD.Irecv((Object)computedModel, 0, 1, MPI.OBJECT, MPI.ANY_SOURCE, 1);
            Model[] modelToSend = new Model[]{model};
            Status requestStatus = modelRequest.Wait();
            if (computedModel[0] != null) {
                int index = modelSet.indexOf(computedModel[0]);
                modelSet.set(index, computedModel[0]);
                this.caller.setCheckpoint(modelSet);
            }
            Request modelSend = MPI.COMM_WORLD.Isend((Object)modelToSend, 0, 1, MPI.OBJECT, requestStatus.source, 2);
            int n = requestStatus.source;
            this.itemsPerProc[n] = this.itemsPerProc[n] + 1;
            modelSend.Wait();
        }
        this.displs[0] = 0;
        for (i = 1; i < this.mpjSize; ++i) {
            this.displs[i] = this.displs[i - 1] + this.itemsPerProc[i - 1];
        }
        for (i = 1; i < this.mpjSize; ++i) {
            Model[] computedModel = new Model[1];
            Request modelRequest = MPI.COMM_WORLD.Irecv((Object)computedModel, 0, 1, MPI.OBJECT, MPI.ANY_SOURCE, 1);
            Model[] modelToSend = new Model[]{null};
            Status requestStatus = modelRequest.Wait();
            if (computedModel[0] != null) {
                int index = modelSet.indexOf(computedModel[0]);
                modelSet.set(index, computedModel[0]);
                this.caller.setCheckpoint(modelSet);
            }
            Request modelSend = MPI.COMM_WORLD.Isend((Object)modelToSend, 0, 1, MPI.OBJECT, requestStatus.source, 2);
            modelSend.Wait();
        }
        while (!this.caller.rootModelRequest) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new ProtTestInternalException("Thread interrupted");
            }
        }
        this.caller.rootModel = null;
        this.caller.rootModelRequest = false;
    }
}

