/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade.strategy;

import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.observer.ModelUpdaterObserver;
import es.uvigo.darwin.prottest.observer.ObservableModelUpdater;
import es.uvigo.darwin.prottest.util.checkpoint.CheckPointManager;
import es.uvigo.darwin.prottest.util.checkpoint.status.ProtTestStatus;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.comparator.ModelWeightComparator;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.factory.ProtTestFactory;

public abstract class DistributionStrategy
extends ObservableModelUpdater
implements ModelUpdaterObserver {
    protected ApplicationOptions options;
    protected ModelCollection modelSet;
    protected int numberOfModels;
    protected int[] itemsPerProc;
    protected int[] displs;
    protected ProtTestFactory factory = ProtTestFactory.getInstance();
    protected int mpjMe;
    protected int mpjSize;
    protected long startTime;
    protected long endTime;
    private CheckPointManager cpManager;

    public DistributionStrategy(int mpjMe, int mpjSize, ApplicationOptions options, CheckPointManager cpManager) {
        this.options = options;
        this.mpjMe = mpjMe;
        this.mpjSize = mpjSize;
        this.cpManager = cpManager;
    }

    public abstract Model[] distribute(ModelCollection var1, ModelWeightComparator var2);

    public abstract void request();

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public void update(ObservableModelUpdater o, Model model, ApplicationOptions options) {
        this.notifyObservers(model, options);
    }

    protected void setCheckpoint(ModelCollection modelSet) {
        if (this.mpjMe > 0) {
            throw new ProtTestInternalException("Only root process can set checkpoints");
        }
        if (this.cpManager != null) {
            ProtTestStatus newStatus = new ProtTestStatus(modelSet.toArray(new Model[0]), this.options);
            this.cpManager.setStatus(newStatus);
        }
    }

    protected void computationDone() {
        if (this.mpjMe > 0) {
            throw new ProtTestInternalException("Only root process can set checkpoints");
        }
        this.cpManager.done();
    }
}

