/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade;

import es.uvigo.darwin.prottest.consensus.Consensus;
import es.uvigo.darwin.prottest.facade.TreeFacade;
import es.uvigo.darwin.prottest.selection.InformationCriterion;
import es.uvigo.darwin.prottest.tree.TreeUtils;
import es.uvigo.darwin.prottest.tree.WeightedTree;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import pal.tree.Tree;

public class TreeFacadeImpl
implements TreeFacade {
    @Override
    public String toASCII(Tree tree) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        TreeUtils.printASCII(tree, pw);
        pw.flush();
        return sw.toString();
    }

    @Override
    public String branchInfo(Tree tree) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        TreeUtils.printBranchInfo(tree, pw);
        pw.flush();
        return sw.toString();
    }

    @Override
    public String heightInfo(Tree tree) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        TreeUtils.heightInfo(tree, pw);
        pw.flush();
        return sw.toString();
    }

    @Override
    public String toNewick(Tree tree, boolean printLengths, boolean printInternalLabels, boolean printCladeSupport) {
        return TreeUtils.toNewick(tree, printLengths, printInternalLabels, printCladeSupport);
    }

    @Override
    public Tree createConsensusTree(List<WeightedTree> treeColection, double threshold) {
        if (threshold < 0.5 || threshold > 1.0) {
            throw new ProtTestInternalException("Invalid threshold value: " + threshold);
        }
        Consensus consensus = new Consensus(treeColection, threshold, 2);
        Tree cons = consensus.getConsensusTree();
        return cons;
    }

    @Override
    public Tree createConsensusTree(InformationCriterion ic, double threshold) {
        Consensus consensus = this.createConsensus(ic, threshold);
        Tree cons = consensus.getConsensusTree();
        return cons;
    }

    @Override
    public Consensus createConsensus(InformationCriterion ic, double threshold) {
        if (threshold < 0.5 || threshold > 1.0) {
            throw new ProtTestInternalException("Invalid threshold value: " + threshold);
        }
        Consensus consensus = new Consensus(ic, threshold);
        return consensus;
    }
}

