/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade;

import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.facade.ProtTestFacadeImpl;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.observer.ObservableModelUpdater;
import es.uvigo.darwin.prottest.util.ProtTestAlignment;
import es.uvigo.darwin.prottest.util.Utilities;
import es.uvigo.darwin.prottest.util.checkpoint.CheckPointManager;
import es.uvigo.darwin.prottest.util.checkpoint.status.ProtTestStatus;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.comparator.AminoAcidModelNaturalComparator;
import es.uvigo.darwin.prottest.util.comparator.ModelDistributionHeuristic;
import es.uvigo.darwin.prottest.util.factory.ProtTestFactory;
import es.uvigo.darwin.prottest.util.printer.ProtTestFormattedOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ProtTestFacadeThread
extends ProtTestFacadeImpl {
    private CheckPointManager cpManager;
    private ModelCollection modelSet;
    private int poolSize;
    private ProtTestFactory factory = ProtTestFactory.getInstance();
    private ExecutorService threadPool;

    public ProtTestFacadeThread(int poolSize) {
        this.poolSize = poolSize;
    }

    @Override
    public int getNumberOfThreads() {
        return this.poolSize;
    }

    @Override
    public void setNumberOfThreads(int numThreads) {
        this.poolSize = numThreads;
    }

    @Override
    public Model[] analyze(ApplicationOptions options) {
        SingleModelCollection arrayListModel;
        this.threadPool = Executors.newFixedThreadPool(this.poolSize);
        this.println("**********************************************************");
        if (options.getSampleSizeMode() == 0 || options.getSampleSizeMode() == 1) {
            double tmpSampleSize = ProtTestAlignment.calculateShannonSampleSize(options.getAlignment(), options.getSampleSizeMode(), true);
            this.errorln("Shannon entropy based sample size: " + ProtTestFormattedOutput.getDecimalString(tmpSampleSize, 2));
        }
        this.println("Observed number of invariant sites: " + ProtTestAlignment.calculateInvariableSites(options.getAlignment(), false));
        StringWriter sw = new StringWriter();
        ProtTestAlignment.printFrequencies(ProtTestAlignment.getFrequencies(options.getAlignment()), new PrintWriter(sw));
        sw.flush();
        this.println(sw.toString());
        this.println("**********************************************************");
        this.println("");
        Date startDate = new Date();
        long startTime = startDate.getTime();
        int numberOfModels = 0;
        ProtTestStatus initialStatus = new ProtTestStatus(null, options);
        this.cpManager = new CheckPointManager();
        if (this.cpManager.loadStatus(initialStatus)) {
            arrayListModel = new SingleModelCollection(((ProtTestStatus)this.cpManager.getLastCheckpoint()).getModels(), options.getAlignment());
        } else {
            arrayListModel = new SingleModelCollection(options.getAlignment());
            Properties modelProperties = new Properties();
            if (options.isPlusF()) {
                modelProperties.setProperty("plusF", "true");
            }
            arrayListModel.addModelCartesian(options.getMatrices(), options.getDistributions(), modelProperties, options.getAlignment(), options.getTree(), options.ncat);
        }
        ModelDistributionHeuristic comparator = new ModelDistributionHeuristic();
        Collections.sort(arrayListModel, comparator);
        numberOfModels = arrayListModel.size();
        this.modelSet = arrayListModel;
        this.flush();
        RunEstimator[] runenv = new RunEstimator[this.modelSet.size()];
        ArrayList<Callable<Object>> c = new ArrayList<Callable<Object>>();
        int current = 0;
        for (Model model : this.modelSet) {
            runenv[current] = this.factory.createRunEstimator(options, model);
            runenv[current].addObserver(this);
            c.add(Executors.callable(runenv[current]));
            ++current;
        }
        boolean errorsFound = false;
        List futures = null;
        try {
            futures = this.threadPool.invokeAll(c);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (futures != null) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException ex) {
                    errorsFound = true;
                }
                catch (ExecutionException ex) {
                    errorsFound = true;
                }
            }
        }
        long endTime = System.currentTimeMillis();
        for (current = 0; current < runenv.length; ++current) {
            Model model = runenv[current].getModel();
            if (model.isComputed()) continue;
            arrayListModel.remove(model);
            --numberOfModels;
            this.warnln("There were errors computing model " + model.getModelName());
        }
        this.println("");
        this.println("");
        Collections.sort(arrayListModel, new AminoAcidModelNaturalComparator());
        block8: for (Model model : arrayListModel) {
            for (current = 0; current < runenv.length; ++current) {
                if (!runenv[current].getModel().equals(model)) continue;
                runenv[current].report();
                continue block8;
            }
        }
        this.flush();
        Model[] allModels = new Model[numberOfModels];
        this.println("************************************************************");
        String runtimeStr = Utilities.calculateRuntime(startTime, endTime);
        this.println("Date   :  " + new Date().toString());
        this.println("Runtime:  " + runtimeStr);
        this.println("");
        this.println("");
        allModels = arrayListModel.toArray(new Model[0]);
        this.cpManager.done();
        return allModels;
    }

    @Override
    public synchronized void update(ObservableModelUpdater o, Model model, ApplicationOptions options) {
        if (model.isComputed() && options != null && this.cpManager != null) {
            ProtTestStatus newStatus = new ProtTestStatus(this.modelSet.toArray(new Model[0]), options);
            this.cpManager.setStatus(newStatus);
        }
        super.update(o, model, options);
    }
}

