/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade;

import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.facade.ProtTestFacadeImpl;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.observer.ObservableModelUpdater;
import es.uvigo.darwin.prottest.util.ProtTestAlignment;
import es.uvigo.darwin.prottest.util.Utilities;
import es.uvigo.darwin.prottest.util.checkpoint.CheckPointManager;
import es.uvigo.darwin.prottest.util.checkpoint.status.ProtTestStatus;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.factory.ProtTestFactory;
import es.uvigo.darwin.prottest.util.printer.ProtTestFormattedOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Properties;

public class ProtTestFacadeSequential
extends ProtTestFacadeImpl {
    private CheckPointManager cpManager;
    private ModelCollection modelSet;
    private ProtTestFactory factory = ProtTestFactory.getInstance();

    @Override
    public Model[] analyze(ApplicationOptions options) {
        this.println("**********************************************************");
        if (options.getSampleSizeMode() == 0 || options.getSampleSizeMode() == 1) {
            double tmpSampleSize = ProtTestAlignment.calculateShannonSampleSize(options.getAlignment(), options.getSampleSizeMode(), true);
            this.println("Shannon entropy based sample size: " + ProtTestFormattedOutput.getDecimalString(tmpSampleSize, 2));
        }
        this.println("Observed number of invariant sites: " + ProtTestAlignment.calculateInvariableSites(options.getAlignment(), false));
        StringWriter sw = new StringWriter();
        ProtTestAlignment.printFrequencies(ProtTestAlignment.getFrequencies(options.getAlignment()), new PrintWriter(sw));
        sw.flush();
        this.println(sw.toString());
        this.println("**********************************************************");
        this.println("");
        Date startDate = new Date();
        long startTime = startDate.getTime();
        int numberOfModels = 0;
        SingleModelCollection arrayListModel = new SingleModelCollection(options.getAlignment());
        ProtTestStatus initialStatus = new ProtTestStatus(null, options);
        this.cpManager = new CheckPointManager();
        if (this.cpManager.loadStatus(initialStatus)) {
            arrayListModel = new SingleModelCollection(((ProtTestStatus)this.cpManager.getLastCheckpoint()).getModels(), options.getAlignment());
        } else {
            Properties modelProperties = new Properties();
            if (options.isPlusF()) {
                modelProperties.setProperty("plusF", "true");
            }
            arrayListModel.addModelCartesian(options.getMatrices(), options.getDistributions(), modelProperties, options.getAlignment(), options.getTree(), options.ncat);
        }
        numberOfModels = arrayListModel.size();
        this.modelSet = arrayListModel;
        this.flush();
        RunEstimator[] runenv = new RunEstimator[this.modelSet.size()];
        int current = 0;
        for (Model model : this.modelSet) {
            runenv[current] = this.factory.createRunEstimator(options, model);
            runenv[current].addObserver(this);
            runenv[current].run();
            runenv[current].report();
            this.flush();
            ++current;
        }
        long endTime = System.currentTimeMillis();
        Model[] allModels = new Model[numberOfModels];
        this.println("************************************************************");
        String runtimeStr = Utilities.calculateRuntime(startTime, endTime);
        this.println("Date   :  " + new Date().toString());
        this.println("Runtime:  " + runtimeStr);
        this.println("");
        this.println("");
        allModels = this.modelSet.toArray(new Model[0]);
        this.cpManager.done();
        return allModels;
    }

    @Override
    public void update(ObservableModelUpdater o, Model model, ApplicationOptions options) {
        if (model.isComputed() && options != null && this.cpManager != null) {
            ProtTestStatus newStatus = new ProtTestStatus(this.modelSet.toArray(new Model[0]), options);
            this.cpManager.setStatus(newStatus);
        }
        super.update(o, model, options);
    }
}

