/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade;

import es.uvigo.darwin.prottest.exe.util.TemporaryFileManager;
import es.uvigo.darwin.prottest.facade.ProtTestFacadeImpl;
import es.uvigo.darwin.prottest.facade.strategy.DistributionStrategy;
import es.uvigo.darwin.prottest.facade.strategy.DynamicDistributionStrategy;
import es.uvigo.darwin.prottest.facade.strategy.HybridDistributionStrategy;
import es.uvigo.darwin.prottest.facade.strategy.ImprovedDynamicDistributionStrategy;
import es.uvigo.darwin.prottest.facade.strategy.StaticDistributionStrategy;
import es.uvigo.darwin.prottest.global.ApplicationGlobals;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.ProtTestAlignment;
import es.uvigo.darwin.prottest.util.Utilities;
import es.uvigo.darwin.prottest.util.checkpoint.CheckPointManager;
import es.uvigo.darwin.prottest.util.checkpoint.status.ProtTestStatus;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.comparator.AminoAcidModelNaturalComparator;
import es.uvigo.darwin.prottest.util.comparator.ModelDistributionHeuristic;
import es.uvigo.darwin.prottest.util.printer.ProtTestFormattedOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import mpi.MPI;
import pal.tree.Tree;

public class ProtTestFacadeMPJ
extends ProtTestFacadeImpl {
    private DistributionStrategy strategy;
    private boolean mpjRun;
    private int mpjMe;
    private int mpjSize;
    private int poolSize = 1;
    private CheckPointManager cpManager;

    @Override
    public int getNumberOfThreads() {
        return this.poolSize;
    }

    @Override
    public void setNumberOfThreads(int numThreads) {
        this.poolSize = numThreads;
    }

    public ProtTestFacadeMPJ(boolean mpjRun, int mpjMe, int mpjSize) {
        this.mpjRun = mpjRun;
        this.mpjMe = mpjMe;
        this.mpjSize = mpjSize;
    }

    @Override
    protected Tree calculateBionjJTT(ApplicationOptions options) {
        Tree[] t = new Tree[1];
        if (this.mpjMe == 0) {
            t[0] = super.calculateBionjJTT(options);
        }
        MPI.COMM_WORLD.Bcast((Object)t, 0, 1, MPI.OBJECT, 0);
        return t[0];
    }

    @Override
    public Model[] analyze(ApplicationOptions options) {
        String strategyProp;
        SingleModelCollection arrayListModel = null;
        if (this.mpjMe == 0) {
            ProtTestStatus initialStatus = new ProtTestStatus(null, options);
            this.cpManager = new CheckPointManager();
            if (this.cpManager.loadStatus(initialStatus)) {
                arrayListModel = new SingleModelCollection(((ProtTestStatus)this.cpManager.getLastCheckpoint()).getModels(), options.getAlignment());
            } else {
                arrayListModel = new SingleModelCollection(options.getAlignment());
                Properties modelProperties = new Properties();
                if (options.isPlusF()) {
                    modelProperties.setProperty("plusF", "true");
                }
                arrayListModel.addModelCartesian(options.getMatrices(), options.getDistributions(), modelProperties, options.getAlignment(), options.getTree(), options.ncat);
            }
        }
        if ((strategyProp = ApplicationGlobals.APPLICATION_PROPERTIES.getProperty("parallel_strategy", "static")).equals("dynamic")) {
            this.strategy = new DynamicDistributionStrategy(this.mpjMe, this.mpjSize, options, this.cpManager);
        } else if (strategyProp.equals("dynamic_improved")) {
            this.strategy = new ImprovedDynamicDistributionStrategy(this.mpjMe, this.mpjSize, options, this.cpManager);
        } else if (strategyProp.equals("hybrid")) {
            int numberOfThreads;
            try {
                numberOfThreads = Integer.parseInt(ApplicationGlobals.APPLICATION_PROPERTIES.getProperty("number_of_threads", String.valueOf(Runtime.getRuntime().availableProcessors())));
            }
            catch (NumberFormatException ex) {
                numberOfThreads = Runtime.getRuntime().availableProcessors();
            }
            this.setNumberOfThreads(numberOfThreads);
            this.strategy = new HybridDistributionStrategy(this.mpjMe, this.mpjSize, options, this.cpManager, this.getNumberOfThreads());
            TemporaryFileManager.synchronize(options.getAlignment(), options.getTree(), this.getNumberOfThreads());
        } else {
            this.strategy = new StaticDistributionStrategy(this.mpjMe, this.mpjSize, options);
        }
        this.strategy.addObserver(this);
        Model[] allModels = null;
        if (this.mpjMe == 0) {
            this.println("**********************************************************");
            if (options.getSampleSizeMode() == 0 || options.getSampleSizeMode() == 1) {
                double tmpSampleSize = ProtTestAlignment.calculateShannonSampleSize(options.getAlignment(), options.getSampleSizeMode(), true);
                this.errorln("Shannon entropy based sample size: " + ProtTestFormattedOutput.getDecimalString(tmpSampleSize, 2));
            }
            this.println("Observed number of invariant sites: " + ProtTestAlignment.calculateInvariableSites(options.getAlignment(), false));
            StringWriter sw = new StringWriter();
            ProtTestAlignment.printFrequencies(ProtTestAlignment.getFrequencies(options.getAlignment()), new PrintWriter(sw));
            sw.flush();
            this.println(sw.toString());
            this.println("**********************************************************");
            this.println("");
            allModels = this.strategy.distribute(arrayListModel, new ModelDistributionHeuristic());
        } else {
            this.strategy.request();
        }
        long startTime = this.strategy.getStartTime();
        long endTime = this.strategy.getEndTime();
        if (this.mpjRun) {
            long[] runtime = new long[]{endTime - startTime};
            long[] runtimes = new long[this.mpjSize];
            MPI.COMM_WORLD.Gather((Object)runtime, 0, 1, MPI.LONG, (Object)runtimes, 0, 1, MPI.LONG, 0);
            if (this.mpjMe == 0) {
                SingleModelCollection sortedModels = new SingleModelCollection(allModels, options.getAlignment());
                Collections.sort(sortedModels, new AminoAcidModelNaturalComparator());
                for (Model model : sortedModels) {
                    this.println("");
                    model.printReport();
                    this.println("");
                }
                this.println("************************************************************");
                this.println("Date: " + new Date().toString());
                for (int i = 0; i < this.mpjSize; ++i) {
                    this.println("Runtime processor " + i + ":  " + Utilities.arrangeRuntime(runtimes[i]));
                }
                this.println("Minimum runtime: " + Utilities.arrangeRuntime(Utilities.getMin(runtimes)));
                this.println("Maximum runtime: " + Utilities.arrangeRuntime(Utilities.getMax(runtimes)));
                this.println("Average runtime: " + Utilities.arrangeRuntime(Utilities.getAverage(runtimes)));
                this.println("");
                this.println("");
                this.flush();
            }
        } else {
            this.println("************************************************************");
            String runtimeStr = Utilities.calculateRuntime(startTime, endTime);
            this.println("Date   :  " + new Date().toString());
            this.println("Runtime:  " + runtimeStr);
            this.println("");
            this.println("");
        }
        return allModels;
    }
}

