/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.facade;

import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.exe.util.TemporaryFileManager;
import es.uvigo.darwin.prottest.facade.ProtTestFacade;
import es.uvigo.darwin.prottest.facade.util.ProtTestParameterVO;
import es.uvigo.darwin.prottest.facade.util.SelectionChunk;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.observer.ObservableModelUpdater;
import es.uvigo.darwin.prottest.selection.AIC;
import es.uvigo.darwin.prottest.selection.AICc;
import es.uvigo.darwin.prottest.selection.BIC;
import es.uvigo.darwin.prottest.selection.DT;
import es.uvigo.darwin.prottest.selection.InformationCriterion;
import es.uvigo.darwin.prottest.selection.LNL;
import es.uvigo.darwin.prottest.selection.printer.AminoAcidPrintFramework;
import es.uvigo.darwin.prottest.util.ProtTestAlignment;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.exception.AlignmentParseException;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.exception.TreeFormatException;
import es.uvigo.darwin.prottest.util.factory.ProtTestFactory;
import es.uvigo.darwin.prottest.util.fileio.AlignmentReader;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import pal.alignment.Alignment;
import pal.tree.Tree;

public abstract class ProtTestFacadeImpl
extends ObservableModelUpdater
implements ProtTestFacade {
    public static final int AIC = 1;
    public static final int BIC = 2;
    public static final int AICC = 3;
    public static final int DT = 4;
    public static final int LNL = 5;

    @Override
    public void printModelsSorted(InformationCriterion informationCriterion) {
        AminoAcidPrintFramework printFramework = new AminoAcidPrintFramework();
        printFramework.printModelsSorted(informationCriterion);
    }

    @Override
    public Alignment readAlignment(String filename, boolean debug) throws AlignmentParseException, FileNotFoundException, IOException {
        StringWriter sw = new StringWriter();
        Alignment alignment = AlignmentReader.readAlignment(new PrintWriter(sw), filename, debug);
        sw.flush();
        ProtTestLogger.getDefaultLogger().infoln(sw.toString());
        return alignment;
    }

    @Override
    public Tree readTree(PrintWriter out, String filename, boolean debug) throws TreeFormatException, FileNotFoundException, IOException {
        return AlignmentReader.readTree(out, filename, debug);
    }

    @Override
    public void update(ObservableModelUpdater o, Model model, ApplicationOptions options) {
        this.notifyObservers(model, options);
    }

    @Override
    public SelectionChunk computeInformationCriterion(Alignment alignment, Model[] models, int criterion, int sampleSizeMode, double sampleSize, double confidenceInterval) {
        InformationCriterion informationCriterion;
        SingleModelCollection modelCollection = new SingleModelCollection(models, alignment);
        double calculatedSampleSize = ProtTestAlignment.calculateSampleSize(alignment, sampleSizeMode, sampleSize);
        switch (criterion) {
            case 1: {
                informationCriterion = new AIC(modelCollection, confidenceInterval, calculatedSampleSize);
                break;
            }
            case 2: {
                informationCriterion = new BIC(modelCollection, confidenceInterval, calculatedSampleSize);
                break;
            }
            case 3: {
                informationCriterion = new AICc(modelCollection, confidenceInterval, calculatedSampleSize);
                break;
            }
            case 4: {
                informationCriterion = new DT(modelCollection, confidenceInterval, calculatedSampleSize);
                break;
            }
            case 5: {
                informationCriterion = new LNL(modelCollection, confidenceInterval, calculatedSampleSize);
                break;
            }
            default: {
                throw new ProtTestInternalException("Unexistent information criterion");
            }
        }
        return new SelectionChunk(informationCriterion);
    }

    @Override
    public int getNumberOfThreads() {
        return 1;
    }

    @Override
    public void setNumberOfThreads(int numThreads) {
        throw new ProtTestInternalException("No threading support");
    }

    protected Tree calculateBionjJTT(ApplicationOptions options) {
        Model jttModel = ProtTestFactory.getInstance().createModel("JTT", options.getDistribution("Uniform"), new Properties(), options.getAlignment(), null, 0);
        TemporaryFileManager.synchronize(options.getAlignment(), null, 1);
        RunEstimator treeEstimator = ProtTestFactory.getInstance().createRunEstimator(options, jttModel);
        treeEstimator.run();
        return jttModel.getTree();
    }

    @Override
    public Model[] startAnalysis(ApplicationOptions options) {
        if (options.getTreeFile() == null && options.strategyMode == 0) {
            Tree jttTree = this.calculateBionjJTT(options);
            options.setTree(jttTree);
        }
        TemporaryFileManager.synchronize(options.getAlignment(), options.getTree(), this.getNumberOfThreads());
        Model[] models = this.analyze(options);
        return models;
    }

    public abstract Model[] analyze(ApplicationOptions var1);

    @Override
    public ApplicationOptions configure(ProtTestParameterVO parameters) throws IOException, AlignmentParseException, ProtTestInternalException {
        ApplicationOptions options = new ApplicationOptions();
        if (parameters.getAlignment() != null) {
            options.setAlignment(parameters.getAlignment());
            options.setAlignmentFilename(parameters.getAlignmentFilePath());
        } else {
            options.setAlignment(parameters.getAlignmentFilePath());
        }
        options.setNumberOfCategories(parameters.ncat);
        for (String matrix : parameters.getMatrices()) {
            options.addMatrix(matrix);
        }
        for (String distribution : parameters.getDistributions()) {
            options.addDistribution(distribution);
        }
        options.setPlusF(parameters.isPlusF());
        options.setTreeFile(parameters.getTreeFilePath());
        options.setStrategyMode(parameters.getStrategyMode());
        return options;
    }

    protected void print(String message) {
        ProtTestLogger.info(message, ProtTestFacade.class);
    }

    protected void println(String message) {
        ProtTestLogger.infoln(message, ProtTestFacade.class);
    }

    protected void error(String message) {
        ProtTestLogger.severe(message, ProtTestFacade.class);
    }

    protected void errorln(String message) {
        ProtTestLogger.severeln(message, ProtTestFacade.class);
    }

    protected void warnln(String message) {
        ProtTestLogger.warningln(message, ProtTestFacade.class);
    }

    protected void verbose(String message) {
        ProtTestLogger.fine(message, ProtTestFacade.class);
    }

    protected void verboseln(String message) {
        ProtTestLogger.fineln(message, ProtTestFacade.class);
    }

    protected void flush() {
        ProtTestLogger.flush(ProtTestFacade.class);
    }
}

