/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.exe.util;

import es.uvigo.darwin.prottest.facade.thread.ThreadPoolSynchronizer;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import pal.alignment.Alignment;
import pal.alignment.AlignmentUtils;
import pal.tree.Tree;
import pal.tree.TreeUtils;

public class TemporaryFileManager {
    private static final String BASE_ALIGNMENT_FILE_NAME = "prottest_alignment_";
    private static final String BASE_TREE_FILE_NAME = "prottest_tree_";
    private static final String BASE_LOG_FILE_NAME = "prottest_";
    private static TemporaryFileManager instance;
    private File[] alignmentTempFile;
    private File[] logTempFile;
    private File treeTempFile;
    private ThreadPoolSynchronizer synchronizer;
    private Alignment alignment;
    private Tree tree;

    public String getAlignmentFilename(Thread thread) {
        int threadId = this.synchronizer.getThreadId(thread);
        return this.alignmentTempFile[threadId].getAbsolutePath();
    }

    public String getLogFilename(Thread thread) {
        int threadId = this.synchronizer.getThreadId(thread);
        return this.logTempFile[threadId].getAbsolutePath();
    }

    public String getTreeFilename(Thread thread) {
        if (this.tree == null) {
            return null;
        }
        return this.treeTempFile.getAbsolutePath();
    }

    public static boolean isSynchronized() {
        return instance != null;
    }

    public void setTree(Tree tree) {
        if (this.tree == null) {
            this.convertTree(tree, this.treeTempFile);
            this.tree = tree;
        } else if (!tree.equals(this.tree)) {
            throw new ProtTestInternalException("Attempting to set different trees");
        }
    }

    public Tree getTree() {
        return this.tree;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    private TemporaryFileManager(Alignment alignment, Tree tree, int poolSize) {
        this.alignmentTempFile = new File[poolSize];
        this.logTempFile = new File[poolSize];
        this.alignment = alignment;
        this.tree = tree;
        try {
            for (int i = 0; i < poolSize; ++i) {
                this.alignmentTempFile[i] = File.createTempFile(BASE_ALIGNMENT_FILE_NAME, null);
                this.alignmentTempFile[i].deleteOnExit();
                this.logTempFile[i] = File.createTempFile(BASE_LOG_FILE_NAME, null);
                this.logTempFile[i].deleteOnExit();
                this.convertAlignment(alignment, this.alignmentTempFile[i]);
            }
            this.treeTempFile = File.createTempFile(BASE_TREE_FILE_NAME, null);
            this.treeTempFile.deleteOnExit();
            if (tree != null) {
                this.convertTree(tree, this.treeTempFile);
            }
        }
        catch (IOException e) {
            throw new ProtTestInternalException("Cannot create temporary files");
        }
        ThreadPoolSynchronizer.synchronize(poolSize);
        this.synchronizer = ThreadPoolSynchronizer.getInstance();
    }

    public static TemporaryFileManager getInstance() {
        if (instance == null) {
            throw new ProtTestInternalException("TemporaryFileManager out of sync");
        }
        return instance;
    }

    public static void synchronize(Alignment alignment, Tree tree, int poolSize) {
        instance = new TemporaryFileManager(alignment, tree, poolSize);
    }

    private boolean convertAlignment(Alignment alignment, File outputFile) {
        try {
            FileOutputStream fo = new FileOutputStream(outputFile);
            PrintWriter output = new PrintWriter(fo);
            AlignmentUtils.printInterleaved((Alignment)alignment, (PrintWriter)output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new ProtTestInternalException();
        }
        return true;
    }

    private boolean convertTree(Tree tree, File outputFile) {
        if (tree != null) {
            try {
                FileOutputStream fo = new FileOutputStream(outputFile);
                PrintWriter output = new PrintWriter(fo);
                TreeUtils.printNH((Tree)tree, (PrintWriter)output);
                output.flush();
                output.close();
            }
            catch (IOException e) {
                throw new ProtTestInternalException();
            }
        }
        return true;
    }
}

