/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.exe;

import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.observer.ObservableModelUpdater;
import es.uvigo.darwin.prottest.util.exception.ModelOptimizationException;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;

public abstract class RunEstimatorImpl
extends ObservableModelUpdater
implements RunEstimator {
    protected ApplicationOptions options;
    protected Model model;
    private boolean optimized;
    protected String time;
    protected int numberOfCategories;
    protected Process proc = null;
    protected int numberOfThreads = 1;

    @Override
    public Model getModel() {
        return this.model;
    }

    protected int getPoolSize() {
        return 1;
    }

    public String getTime() {
        if (this.optimized) {
            return this.time;
        }
        throw new ProtTestInternalException("The model is not optimized");
    }

    public RunEstimatorImpl(ApplicationOptions options, Model model) {
        this(options, model, 1);
    }

    public RunEstimatorImpl(ApplicationOptions options, Model model, int numberOfThreads) {
        this.options = options;
        this.model = model;
        this.optimized = model.isComputed();
        this.numberOfThreads = numberOfThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean optimizeModel() {
        this.notifyObservers(this.getModel(), null);
        boolean result = true;
        try {
            if (!this.optimized) {
                result = this.runEstimator();
            }
        }
        catch (ModelOptimizationException ex) {
            ProtTestLogger.severeln(ex.getMessage(), RunEstimator.class);
        }
        finally {
            this.notifyObservers(this.getModel(), this.options);
            this.deleteTemporaryFiles();
        }
        this.optimized = result;
        return result;
    }

    @Override
    public void report() {
        if (!this.optimized) {
            throw new ProtTestInternalException("The model is not optimized");
        }
        this.printReport();
    }

    public abstract boolean runEstimator() throws ModelOptimizationException;

    public abstract void printReport();

    protected abstract boolean deleteTemporaryFiles();

    @Override
    public void run() {
        if (!this.optimizeModel()) {
            throw new ProtTestInternalException("Optimization error");
        }
    }

    protected void print(String message) {
        ProtTestLogger.info(message, RunEstimator.class);
    }

    protected void println(String message) {
        ProtTestLogger.infoln(message, RunEstimator.class);
    }

    protected void error(String message) {
        ProtTestLogger.severe(message, RunEstimator.class);
    }

    protected void errorln(String message) {
        ProtTestLogger.severeln(message, RunEstimator.class);
    }

    protected void pfine(String message) {
        ProtTestLogger.fine(message, RunEstimator.class);
    }

    protected void pfineln(String message) {
        ProtTestLogger.fineln(message, RunEstimator.class);
    }

    protected void pfiner(String message) {
        ProtTestLogger.finer(message, RunEstimator.class);
    }

    protected void pfinerln(String message) {
        ProtTestLogger.finerln(message, RunEstimator.class);
    }
}

