/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.exe;

import es.uvigo.darwin.prottest.exe.AminoAcidRunEstimator;
import es.uvigo.darwin.prottest.exe.ExternalExecutionManager;
import es.uvigo.darwin.prottest.exe.RaxMLStreamGobbler;
import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.exe.util.TemporaryFileManager;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.AminoAcidModel;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.Utilities;
import es.uvigo.darwin.prottest.util.exception.ModelOptimizationException;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.exception.TreeFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import pal.tree.ReadTree;
import pal.tree.Tree;
import pal.tree.TreeParseException;

public class RaxMLAminoAcidRunEstimator
extends AminoAcidRunEstimator {
    public static final String PARSIMONY_TREE_PREFIX = "RAxML_parsimonyTree.";
    public static final String FINAL_TREE_PREFIX = "RAxML_result.";
    public static final String STATS_PREFIX = "RAxML_info.";
    public static final String LOG_PREFIX = "RAxML_log.";
    private String workAlignment;
    private File modelFile;
    private String outputAppend;

    public RaxMLAminoAcidRunEstimator(ApplicationOptions options, Model model) {
        this(options, model, 1);
    }

    public RaxMLAminoAcidRunEstimator(ApplicationOptions options, Model model, int numberOfThreads) {
        super(options, model, numberOfThreads);
        this.numberOfCategories = options.ncat;
        try {
            this.model = (AminoAcidModel)model;
            this.modelFile = new File("models" + File.separator + model.getMatrix());
        }
        catch (ClassCastException cce) {
            throw new ProtTestInternalException("Wrong model type");
        }
        this.outputAppend = model.getModelName().replace('+', 'P');
        System.out.println(" MODEL, OUTPUT " + model.getModelName() + " " + this.outputAppend);
    }

    @Override
    public boolean runEstimator() throws ModelOptimizationException {
        block21: {
            this.workAlignment = TemporaryFileManager.getInstance().getAlignmentFilename(Thread.currentThread());
            switch (this.options.strategyMode) {
                case 1: {
                    break;
                }
                case 0: {
                    if (TemporaryFileManager.getInstance().getTreeFilename(Thread.currentThread()) == null) break;
                    break;
                }
                case 2: {
                    break;
                }
            }
            try {
                int i;
                Runtime runtime = Runtime.getRuntime();
                String[] str = new String[26];
                for (int i2 = 0; i2 < str.length; ++i2) {
                    str[i2] = "";
                }
                String raxmlBinName = "raxmlHPC";
                if (raxmlBinName != null) {
                    str[0] = raxmlBinName;
                    str[1] = "-s";
                    str[2] = this.workAlignment;
                    File f = new File(this.workAlignment);
                    str[5] = "-n";
                    str[6] = this.outputAppend;
                    StringBuilder modelName = new StringBuilder("PROT");
                    if (this.model.isGamma()) {
                        modelName.append("GAMMA");
                    } else {
                        modelName.append("MIX");
                    }
                    if (this.model.isInv()) {
                        modelName.append("I");
                    }
                    modelName.append(this.model.getMatrix().toUpperCase());
                    if (this.model.isPlusF()) {
                        modelName.append("F");
                    }
                    str[3] = "-m";
                    str[4] = modelName.toString();
                    System.out.print("COMMAND: ");
                    for (String tok : str) {
                        System.out.print(tok + " ");
                    }
                } else {
                    ModelOptimizationException.OSNotSupportedException e = new ModelOptimizationException.OSNotSupportedException("PhyML");
                    throw e;
                }
                System.out.println(" ");
                this.model.setCommandLine(str);
                this.proc = runtime.exec(str);
                this.proc.getOutputStream().write(this.modelFile.getPath().getBytes());
                ExternalExecutionManager.getInstance().addProcess(this.proc);
                this.proc.getOutputStream().close();
                RaxMLStreamGobbler errorGobbler = new RaxMLStreamGobbler(new InputStreamReader(this.proc.getErrorStream()), "RAxML-Error", true, RunEstimator.class);
                RaxMLStreamGobbler outputGobbler = new RaxMLStreamGobbler(new InputStreamReader(this.proc.getInputStream()), "RAxML-Output", true, RunEstimator.class);
                errorGobbler.start();
                outputGobbler.start();
                int exitVal = this.proc.waitFor();
                ExternalExecutionManager.getInstance().removeProcess(this.proc);
                this.pfine("RAxML command-line: ");
                for (i = 0; i < str.length; ++i) {
                    this.pfine(str[i] + " ");
                }
                this.pfineln("");
                if (exitVal == 0) break block21;
                this.errorln("RAxML exit value: " + exitVal + " (there was probably some error)");
                this.error("RAxML command-line: ");
                for (i = 0; i < str.length; ++i) {
                    this.error(str[i] + " ");
                }
                this.errorln("");
                this.errorln("Please, take a look at the RAxML log below:");
                try {
                    String line;
                    FileReader input = new FileReader(TemporaryFileManager.getInstance().getLogFilename(Thread.currentThread()));
                    BufferedReader br = new BufferedReader(input);
                    while ((line = br.readLine()) != null) {
                        this.errorln(line);
                    }
                }
                catch (IOException e) {
                    this.errorln("Unable to read the log file: " + TemporaryFileManager.getInstance().getLogFilename(Thread.currentThread()));
                }
            }
            catch (InterruptedException e) {
                throw new ModelOptimizationException.PhyMLExecutionException("Interrupted execution: " + e.getMessage());
            }
            catch (IOException e) {
                throw new ModelOptimizationException.PhyMLExecutionException("I/O error: " + e.getMessage());
            }
        }
        return this.readStatsFile() && this.readTreeFile();
    }

    @Override
    protected boolean deleteTemporaryFiles() {
        return true;
    }

    private boolean readStatsFile() throws ModelOptimizationException {
        String logLK = null;
        String inv = null;
        String alpha = null;
        try {
            String line;
            FileReader input = new FileReader(STATS_PREFIX + this.outputAppend);
            BufferedReader br = new BufferedReader(input);
            while ((line = br.readLine()) != null) {
                this.pfinerln("[DEBUG] RAXML: " + line);
                if (line.length() <= 0) continue;
                if (line.startsWith("Substitution Matrix:")) {
                    String matrixName = Utilities.lastToken(line);
                    if (this.model.getMatrix().equalsIgnoreCase(matrixName)) continue;
                    String errorMsg = "Matrix names doesn't match";
                    this.errorln("RAXML: " + line);
                    this.errorln("Last token: " + Utilities.lastToken(line));
                    this.errorln("It should be: " + this.model.getMatrix());
                    this.errorln(errorMsg);
                    throw new ModelOptimizationException.ModelNotFoundException(this.model.getMatrix());
                }
                if (line.startsWith("Likelihood   :")) {
                    logLK = Utilities.lastToken(line);
                    continue;
                }
                if (line.startsWith("Inference[0]")) {
                    alpha = Utilities.nextToken(line, "alpha[0]:");
                    inv = Utilities.nextToken(line, "invar[0]:");
                    this.pfinerln("[DEBUG] RAXML: " + line);
                    continue;
                }
                if (!line.startsWith("Overall Time")) continue;
                this.time = Utilities.lastToken(line);
            }
            this.model.setLk(Double.parseDouble(logLK));
            if (alpha != null) {
                this.model.setAlpha(Double.parseDouble(alpha));
            }
            if (inv != null) {
                this.model.setInv(Double.parseDouble(inv));
            }
        }
        catch (IOException e) {
            throw new ModelOptimizationException.StatsFileFormatException("RAxML", e.getMessage());
        }
        return true;
    }

    private boolean readTreeFile() throws TreeFormatException {
        try {
            this.model.setTree((Tree)new ReadTree(FINAL_TREE_PREFIX + this.outputAppend));
        }
        catch (TreeParseException e) {
            String errorMsg = "ProtTest: wrong tree format, exiting...";
            throw new TreeFormatException(errorMsg);
        }
        catch (IOException e) {
            String errorMsg = "Error: File not found (IO error), exiting...";
            throw new TreeFormatException(errorMsg);
        }
        return true;
    }
}

