/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.exe;

import es.uvigo.darwin.prottest.exe.AminoAcidRunEstimator;
import es.uvigo.darwin.prottest.exe.ExternalExecutionManager;
import es.uvigo.darwin.prottest.exe.PhymlStreamGobbler;
import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.exe.util.TemporaryFileManager;
import es.uvigo.darwin.prottest.global.AminoAcidApplicationGlobals;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.AminoAcidModel;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.util.Utilities;
import es.uvigo.darwin.prottest.util.exception.ModelOptimizationException;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.exception.TreeFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import pal.tree.ReadTree;
import pal.tree.Tree;
import pal.tree.TreeParseException;

public class PhyMLv3AminoAcidRunEstimator
extends AminoAcidRunEstimator {
    public static String[] IMPLEMENTED_MATRICES = new String[]{"JTT", "LG", "DCMut", "MtREV", "MtMam", "MtArt", "Dayhoff", "WAG", "RtREV", "CpREV", "Blosum62", "VT", "HIVb", "HIVw"};
    private static final String STATS_FILE_SUFFIX = "_phyml_stats.txt";
    private static final String TREE_FILE_SUFFIX = "_phyml_tree.txt";
    private String workAlignment;
    private File modelFile;

    public PhyMLv3AminoAcidRunEstimator(ApplicationOptions options, Model model) {
        this(options, model, 1);
    }

    public PhyMLv3AminoAcidRunEstimator(ApplicationOptions options, Model model, int numberOfThreads) {
        super(options, model, numberOfThreads);
        this.numberOfCategories = options.ncat;
        try {
            this.model = (AminoAcidModel)model;
            this.modelFile = new File("models" + File.separator + model.getMatrix());
        }
        catch (ClassCastException cce) {
            throw new ProtTestInternalException("Wrong model type");
        }
    }

    @Override
    public boolean runEstimator() throws ModelOptimizationException {
        block27: {
            this.workAlignment = TemporaryFileManager.getInstance().getAlignmentFilename(Thread.currentThread());
            String inv = "0.0";
            if (this.model.isInv()) {
                inv = "e";
            }
            String rateCathegories = "1";
            String alpha = "";
            if (this.model.isGamma()) {
                rateCathegories = "" + this.model.getNumberOfTransitionCategories();
                alpha = "e";
            }
            String tr = "BIONJ";
            String F = "d";
            if (this.model.isPlusF()) {
                F = "e";
            }
            String topo = "lr";
            switch (this.options.strategyMode) {
                case 1: {
                    tr = "BIONJ";
                    topo = "l";
                    break;
                }
                case 0: {
                    if (TemporaryFileManager.getInstance().getTreeFilename(Thread.currentThread()) != null) {
                        tr = TemporaryFileManager.getInstance().getTreeFilename(Thread.currentThread());
                        topo = "l";
                        break;
                    }
                    topo = "r";
                    break;
                }
                case 2: {
                    topo = "tl";
                    break;
                }
                case 3: {
                    tr = TemporaryFileManager.getInstance().getTreeFilename(Thread.currentThread());
                    topo = "l";
                }
            }
            try {
                int i;
                Runtime runtime = Runtime.getRuntime();
                String[] str = new String[29];
                for (int i2 = 0; i2 < str.length; ++i2) {
                    str[i2] = "";
                }
                File currentDir = new File("");
                File phymlBin = new File(currentDir.getAbsolutePath() + "/bin/phyml");
                String phymlBinName = phymlBin.exists() && phymlBin.canExecute() ? phymlBin.getAbsolutePath() : currentDir.getAbsolutePath() + "/bin/" + this.getPhymlVersion();
                if (phymlBinName != null) {
                    str[0] = phymlBinName;
                    str[4] = "-i";
                    str[5] = this.workAlignment;
                    str[6] = "-c";
                    str[7] = rateCathegories;
                    str[8] = "-m";
                    if (!Arrays.asList(IMPLEMENTED_MATRICES).contains(this.model.getMatrix())) {
                        if (!this.modelFile.exists()) {
                            throw new ModelOptimizationException.ModelNotFoundException(this.model.getMatrix());
                        }
                        str[9] = "custom";
                        str[27] = "--aa_rate_file";
                        str[28] = this.modelFile.getAbsolutePath();
                    } else {
                        str[9] = this.model.getMatrix();
                    }
                    str[10] = "-v";
                    str[11] = inv;
                    if (!alpha.equals("")) {
                        str[12] = "-a";
                        str[13] = alpha;
                    }
                    str[14] = "-o";
                    str[15] = topo;
                    str[16] = "-f";
                    str[17] = F;
                    if (!tr.equals("BIONJ")) {
                        str[18] = "-u";
                        str[19] = tr;
                    }
                    str[20] = "-d";
                    str[21] = "aa";
                    str[22] = "-b";
                    str[23] = "0";
                    if (AminoAcidApplicationGlobals.APPLICATION_PROPERTIES.getProperty("phyml_thread_scheduling", "false").equalsIgnoreCase("true")) {
                        str[24] = "--num_threads";
                        str[25] = String.valueOf(this.numberOfThreads);
                    }
                } else {
                    ModelOptimizationException.OSNotSupportedException e = new ModelOptimizationException.OSNotSupportedException("PhyML");
                    throw e;
                }
                str[26] = "--no_memory_check";
                this.model.setCommandLine(str);
                this.proc = runtime.exec(str);
                this.proc.getOutputStream().write(this.modelFile.getPath().getBytes());
                ExternalExecutionManager.getInstance().addProcess(this.proc);
                this.proc.getOutputStream().close();
                PhymlStreamGobbler errorGobbler = new PhymlStreamGobbler(new InputStreamReader(this.proc.getErrorStream()), "Phyml-Error", true, RunEstimator.class);
                PhymlStreamGobbler outputGobbler = new PhymlStreamGobbler(new InputStreamReader(this.proc.getInputStream()), "Phyml-Output", true, RunEstimator.class);
                errorGobbler.start();
                outputGobbler.start();
                int exitVal = this.proc.waitFor();
                ExternalExecutionManager.getInstance().removeProcess(this.proc);
                this.pfine("Phyml's command-line: ");
                for (i = 0; i < str.length; ++i) {
                    this.pfine(str[i] + " ");
                }
                this.pfineln("");
                if (exitVal == 0) break block27;
                this.errorln("Phyml's exit value: " + exitVal + " (there was probably some error)");
                this.error("Phyml's command-line: ");
                for (i = 0; i < str.length; ++i) {
                    this.error(str[i] + " ");
                }
                this.errorln("");
                this.errorln("Please, take a look at the Phyml's log below:");
                try {
                    String line;
                    FileReader input = new FileReader(TemporaryFileManager.getInstance().getLogFilename(Thread.currentThread()));
                    BufferedReader br = new BufferedReader(input);
                    while ((line = br.readLine()) != null) {
                        this.errorln(line);
                    }
                }
                catch (IOException e) {
                    this.errorln("Unable to read the log file: " + TemporaryFileManager.getInstance().getLogFilename(Thread.currentThread()));
                }
            }
            catch (InterruptedException e) {
                throw new ModelOptimizationException.PhyMLExecutionException("Interrupted execution: " + e.getMessage());
            }
            catch (IOException e) {
                throw new ModelOptimizationException.PhyMLExecutionException("I/O error: " + e.getMessage());
            }
        }
        return this.readStatsFile() && this.readTreeFile();
    }

    private boolean readStatsFile() throws ModelOptimizationException {
        try {
            String line;
            FileReader input = new FileReader(this.workAlignment + STATS_FILE_SUFFIX);
            BufferedReader br = new BufferedReader(input);
            while ((line = br.readLine()) != null) {
                this.pfinerln("[DEBUG] PHYML: " + line);
                if (line.length() <= 0) continue;
                if (line.startsWith(". Model of amino acids substitution")) {
                    String matrixName = Utilities.lastToken(line);
                    if (this.model.getMatrix().equals("HIVw") || this.model.getMatrix().equals(matrixName) || this.modelFile.exists() && matrixName.equals("Custom")) continue;
                    String errorMsg = "Matrix names doesn't match";
                    this.errorln("PHYML: " + line);
                    this.errorln("Last token: " + Utilities.lastToken(line));
                    this.errorln("It should be: " + this.model.getMatrix());
                    this.errorln(errorMsg);
                    throw new ModelOptimizationException.ModelNotFoundException(this.model.getMatrix());
                }
                if (line.startsWith(". Log-likelihood")) {
                    this.model.setLk(Double.parseDouble(Utilities.lastToken(line)));
                    continue;
                }
                if (line.startsWith(". Discrete gamma model")) {
                    if (!Utilities.lastToken(line).equals("Yes")) continue;
                    line = br.readLine();
                    this.pfinerln("[DEBUG] PHYML: " + line);
                    if (this.model.getNumberOfTransitionCategories() != Integer.parseInt(Utilities.lastToken(line))) {
                        String errorMsg = "There were errors in the number of transition categories: " + this.model.getNumberOfTransitionCategories() + " vs " + Integer.parseInt(Utilities.lastToken(line));
                        this.errorln(errorMsg);
                        throw new ModelOptimizationException.StatsFileFormatException("PhyML", errorMsg);
                    }
                    line = br.readLine();
                    this.pfinerln("[DEBUG] PHYML: " + line);
                    this.model.setAlpha(Double.parseDouble(Utilities.lastToken(line)));
                    continue;
                }
                if (line.startsWith(". Proportion of invariant:")) {
                    this.model.setInv(Double.parseDouble(Utilities.lastToken(line)));
                    continue;
                }
                if (!line.startsWith(". Time used")) continue;
                this.time = Utilities.lastToken(line);
            }
        }
        catch (IOException e) {
            throw new ModelOptimizationException.StatsFileFormatException("PhyML", e.getMessage());
        }
        return true;
    }

    private boolean readTreeFile() throws TreeFormatException {
        try {
            this.model.setTree((Tree)new ReadTree(this.workAlignment + TREE_FILE_SUFFIX));
        }
        catch (TreeParseException e) {
            String errorMsg = "ProtTest: wrong tree format, exiting...";
            throw new TreeFormatException(errorMsg);
        }
        catch (IOException e) {
            String errorMsg = "Error: File not found (IO error), exiting...";
            throw new TreeFormatException(errorMsg);
        }
        return true;
    }

    @Override
    protected boolean deleteTemporaryFiles() {
        File f = new File(this.workAlignment + STATS_FILE_SUFFIX);
        f.delete();
        f = new File(this.workAlignment + TREE_FILE_SUFFIX);
        f.delete();
        f = new File(TemporaryFileManager.getInstance().getLogFilename(Thread.currentThread()));
        f.delete();
        return true;
    }

    private String getPhymlVersion() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac")) {
            String oa = System.getProperty("os.arch");
            if (oa.startsWith("ppc")) {
                return "phyml-prottest-macppc";
            }
            return "phyml-prottest-macintel";
        }
        if (os.startsWith("Linux")) {
            return "phyml-prottest-linux";
        }
        if (os.startsWith("Window")) {
            return "phyml-prottest-windows.exe";
        }
        return null;
    }
}

