/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.exe;

import es.uvigo.darwin.prottest.exe.RunEstimator;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.observer.ModelUpdaterObserver;
import es.uvigo.darwin.prottest.observer.ObservableModelUpdater;
import es.uvigo.darwin.prottest.util.collection.ModelCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import pal.alignment.Alignment;

public class ParallelModelEstimator
extends ObservableModelUpdater
implements ModelUpdaterObserver {
    private Runtime runtime = Runtime.getRuntime();
    private int maxNumberOfTasks;
    private List<RunEstimator> estimatorList;
    private ExecutorService threadPool;
    private Collection<Callable<Object>> c = new ArrayList<Callable<Object>>();

    public ParallelModelEstimator(Alignment alignment) {
        this(-1, alignment);
    }

    public ParallelModelEstimator(ModelCollection modelCollection) {
        this(-1, modelCollection);
    }

    public ParallelModelEstimator(int availableThreads, Alignment alignment) {
        if (availableThreads < 0) {
            availableThreads = this.runtime.availableProcessors();
        }
        this.maxNumberOfTasks = availableThreads;
        this.estimatorList = new ArrayList<RunEstimator>(this.maxNumberOfTasks);
        this.threadPool = Executors.newFixedThreadPool(this.maxNumberOfTasks);
    }

    public ParallelModelEstimator(int availableThreads, ModelCollection modelCollection) {
        if (availableThreads < 0) {
            availableThreads = this.runtime.availableProcessors();
        }
        this.estimatorList = new ArrayList<RunEstimator>(this.maxNumberOfTasks);
    }

    public boolean execute(RunEstimator estimator) {
        estimator.addObserver(this);
        boolean added = this.estimatorList.add(estimator);
        this.c.add(Executors.callable(estimator));
        Object futures = null;
        this.threadPool.execute(estimator);
        return added;
    }

    @Override
    public void update(ObservableModelUpdater o, Model model, ApplicationOptions options) {
        this.notifyObservers(model, options);
    }

    public boolean hasMoreTasks() {
        for (RunEstimator estimator : this.estimatorList) {
            if (estimator.getModel().isComputed()) continue;
            return true;
        }
        return false;
    }
}

