/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.exe;

import es.uvigo.darwin.prottest.exe.ExternalExecutionManager;
import es.uvigo.darwin.prottest.exe.util.TemporaryFileManager;
import es.uvigo.darwin.prottest.util.exception.ModelOptimizationException;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ExternalExecutor {
    private static final int STATE_NULL = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_EXECUTED = 2;
    private static final int OUTPUT_STANDARD = 1;
    private static final int OUTPUT_TEMPORARY = 2;
    private String command;
    private Process proc = null;
    private OutputStream logOutput;
    private int internal_state = 0;

    public ExternalExecutor(String command, int outLogFormat) throws ModelOptimizationException.ExternalExecutionException {
        try {
            this.command = command;
            switch (outLogFormat) {
                case 1: {
                    this.logOutput = System.out;
                    break;
                }
                case 2: {
                    this.logOutput = new FileOutputStream(TemporaryFileManager.getInstance().getLogFilename(Thread.currentThread()));
                }
            }
            this.internal_state = 1;
        }
        catch (FileNotFoundException ex) {
            throw new ModelOptimizationException.ExternalExecutionException("I/O error: " + ex.getMessage());
        }
    }

    public void run() throws ModelOptimizationException.ExternalExecutionException {
        if (!this.checkState(1) || this.checkState(2)) {
            throw new ProtTestInternalException("Invalid executor internal state");
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            this.proc = runtime.exec(this.command);
            ExternalExecutionManager.getInstance().addProcess(this.proc);
        }
        catch (IOException ex) {
            throw new ProtTestInternalException(ex.getMessage());
        }
        try {
            int exitVal = this.proc.waitFor();
        }
        catch (InterruptedException ex) {
            throw new ModelOptimizationException.ExternalExecutionException("Interrupted execution: " + ex.getMessage());
        }
    }

    private boolean checkState(int state) {
        return this.internal_state >= state;
    }
}

