/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest.exe;

import java.util.ArrayList;
import java.util.Collection;

public class ExternalExecutionManager {
    private static ExternalExecutionManager instance;
    private final Collection<Process> processes = new ArrayList<Process>();

    private ExternalExecutionManager() {
    }

    public static ExternalExecutionManager getInstance() {
        if (instance == null) {
            instance = new ExternalExecutionManager();
        }
        return instance;
    }

    public boolean addProcess(Process proc) {
        boolean result = false;
        if (!this.processes.contains(proc)) {
            result = this.processes.add(proc);
        }
        return result;
    }

    public boolean removeProcess(Process proc) {
        boolean result = false;
        if (this.processes.contains(proc)) {
            result = this.processes.remove(proc);
        }
        return result;
    }

    public void killProcesses() {
        for (final Process proc : this.processes) {
            if (proc == null) continue;
            try {
                proc.exitValue();
            }
            catch (IllegalThreadStateException e) {
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        proc.destroy();
                    }
                }));
            }
        }
        this.processes.clear();
    }
}

