/*
 * Decompiled with CFR 0.152.
 */
package es.uvigo.darwin.prottest;

import es.uvigo.darwin.prottest.consensus.Consensus;
import es.uvigo.darwin.prottest.facade.ProtTestFacadeImpl;
import es.uvigo.darwin.prottest.facade.ProtTestFacadeMPJ;
import es.uvigo.darwin.prottest.facade.ProtTestFacadeSequential;
import es.uvigo.darwin.prottest.facade.ProtTestFacadeThread;
import es.uvigo.darwin.prottest.facade.TreeFacadeImpl;
import es.uvigo.darwin.prottest.global.ApplicationGlobals;
import es.uvigo.darwin.prottest.global.options.ApplicationOptions;
import es.uvigo.darwin.prottest.model.Model;
import es.uvigo.darwin.prottest.observer.ModelUpdaterObserver;
import es.uvigo.darwin.prottest.observer.ObservableModelUpdater;
import es.uvigo.darwin.prottest.selection.AIC;
import es.uvigo.darwin.prottest.selection.AICc;
import es.uvigo.darwin.prottest.selection.BIC;
import es.uvigo.darwin.prottest.selection.DT;
import es.uvigo.darwin.prottest.selection.InformationCriterion;
import es.uvigo.darwin.prottest.selection.LNL;
import es.uvigo.darwin.prottest.selection.printer.PrintFramework;
import es.uvigo.darwin.prottest.util.FixedBitSet;
import es.uvigo.darwin.prottest.util.collection.SingleModelCollection;
import es.uvigo.darwin.prottest.util.exception.ProtTestInternalException;
import es.uvigo.darwin.prottest.util.factory.ProtTestFactory;
import es.uvigo.darwin.prottest.util.logging.ProtTestLogger;
import es.uvigo.darwin.prottest.util.printer.ProtTestPrinter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import mpi.MPI;
import pal.misc.Identifier;
import pal.tree.Tree;

public class ProtTest {
    public static final String versionNumber = "3.0";
    public static final String versionDate = "10th February 2011";
    public static int MPJ_ME;
    public static int MPJ_SIZE;
    public static boolean MPJ_RUN;
    private static ProtTestFactory factory;

    public static void main(String[] args) {
        args = ProtTestFactory.initialize(args);
        factory = ProtTestFactory.getInstance();
        try {
            String[] argsApp = MPI.Init((String[])args);
            MPJ_ME = MPI.COMM_WORLD.Rank();
            MPJ_SIZE = MPI.COMM_WORLD.Size();
            MPJ_RUN = true;
            args = argsApp;
        }
        catch (Exception e) {
            MPJ_ME = 0;
            MPJ_SIZE = 1;
            MPJ_RUN = false;
        }
        ProtTestLogger logger = ProtTestLogger.getDefaultLogger();
        logger.setStdHandlerLevel(Level.INFO);
        if (MPJ_ME == 0) {
            try {
                Handler logHandler = factory.createLogHandler();
                if (logHandler != null) {
                    logger.addHandler(logHandler);
                }
            }
            catch (IOException ex) {
                logger.severeln(ex.getMessage());
            }
        }
        ApplicationOptions opts = new ApplicationOptions();
        int numThreads = 1;
        try {
            numThreads = Integer.parseInt(factory.createProtTestArgumentParser(args, opts).getValue("threads"));
        }
        catch (IllegalArgumentException e) {
            if (MPJ_ME == 0) {
                System.err.println(e.getMessage());
                ApplicationOptions.usage();
            }
            ProtTest.finalize(1);
        }
        catch (ProtTestInternalException e) {
            if (MPJ_ME == 0) {
                System.err.println(e.getMessage());
            }
            ProtTest.finalize(1);
        }
        catch (ExceptionInInitializerError e) {
            if (MPJ_ME == 0) {
                System.err.println("An error has occurred while initializing. Check your prottest.properties file.");
            }
            ProtTest.finalize(1);
        }
        TreeFacadeImpl treeFacade = new TreeFacadeImpl();
        ProtTestFacadeImpl facade = MPJ_RUN ? new ProtTestFacadeMPJ(MPJ_RUN, MPJ_ME, MPJ_SIZE) : (numThreads > 1 ? new ProtTestFacadeThread(numThreads) : new ProtTestFacadeSequential());
        if (MPJ_RUN || numThreads > 1) {
            facade.addObserver(new ModelUpdaterObserver(){

                @Override
                public void update(ObservableModelUpdater o, Model model, ApplicationOptions options) {
                    if (model.isComputed() && options != null) {
                        System.out.println("Computed: " + model.getModelName() + " (" + model.getLk() + ")");
                    } else {
                        System.out.println("Computing " + model.getModelName() + "...");
                    }
                }
            });
        }
        if (opts.isDebug()) {
            logger.setStdHandlerLevel(Level.ALL);
        }
        if (MPJ_ME == 0) {
            ProtTestPrinter.printHeader();
            opts.reportComplete();
        }
        try {
            Model[] models = facade.startAnalysis(opts);
            if (MPJ_ME == 0) {
                InformationCriterion ic;
                SingleModelCollection allModelsList = new SingleModelCollection(models, opts.getAlignment());
                switch (opts.getSortBy()) {
                    case 'A': {
                        ic = new AIC(allModelsList, 1.0, opts.getSampleSize());
                        break;
                    }
                    case 'B': {
                        ic = new BIC(allModelsList, 1.0, opts.getSampleSize());
                        break;
                    }
                    case 'C': {
                        ic = new AICc(allModelsList, 1.0, opts.getSampleSize());
                        break;
                    }
                    case 'D': {
                        ic = new DT(allModelsList, 1.0, opts.getSampleSize());
                        break;
                    }
                    case 'E': {
                        ic = new LNL(allModelsList, 1.0, opts.getSampleSize());
                        break;
                    }
                    default: {
                        throw new ProtTestInternalException("Unrecognized information criterion");
                    }
                }
                facade.printModelsSorted(ic);
                if (opts.isAll()) {
                    PrintFramework.printFrameworksComparison(ic.getModelCollection());
                }
                if (opts.isDisplayASCIITree()) {
                    ProtTestPrinter.printTreeHeader(ic.getBestModel().getModelName());
                    logger.infoln(treeFacade.toASCII(ic.getBestModel().getTree()));
                }
                if (opts.isDisplayNewickTree()) {
                    if (!opts.isDisplayASCIITree()) {
                        ProtTestPrinter.printTreeHeader(ic.getBestModel().getModelName());
                    }
                    logger.infoln(treeFacade.toNewick(ic.getBestModel().getTree(), true, true, false));
                }
                if (opts.isDisplayConsensusTree()) {
                    ProtTestPrinter.printTreeHeader("MODEL AVERAGED PHYLOGENY");
                    Consensus consensus = treeFacade.createConsensus(ic, opts.getConsensusThreshold());
                    logger.infoln("----------------------------------------");
                    logger.infoln("Selection criterion: . . . . " + ApplicationGlobals.SORTBY_NAMES[opts.getSortBy() - 65]);
                    logger.infoln("Confidence interval: . . . . " + ic.getConfidenceInterval());
                    logger.infoln("Sample size: . . . . . . . . " + opts.getSampleSize());
                    logger.infoln("Consensus support threshold: " + opts.getConsensusThreshold());
                    logger.infoln("----------------------------------------");
                    logger.infoln("");
                    Set<FixedBitSet> keySet = consensus.getCladeSupport().keySet();
                    ArrayList<FixedBitSet> splitsInConsensus = new ArrayList<FixedBitSet>();
                    ArrayList<FixedBitSet> splitsOutFromConsensus = new ArrayList<FixedBitSet>();
                    for (FixedBitSet fbs : keySet) {
                        if (fbs.cardinality() <= 1) continue;
                        double psupport = 1.0 * consensus.getCladeSupport().get(fbs) / 1.0;
                        if (psupport < opts.getConsensusThreshold()) {
                            splitsOutFromConsensus.add(fbs);
                            continue;
                        }
                        splitsInConsensus.add(fbs);
                    }
                    logger.infoln("# # # # # # # # # # # # # # # #");
                    logger.infoln(" ");
                    logger.infoln("Species in order:");
                    logger.infoln(" ");
                    for (int i = 0; i < consensus.getIdGroup().getIdCount(); ++i) {
                        Identifier id = consensus.getIdGroup().getIdentifier(i);
                        logger.infoln("    " + (i + 1) + ". " + id.getName());
                    }
                    logger.infoln(" ");
                    logger.infoln("# # # # # # # # # # # # # # # #");
                    logger.infoln(" ");
                    logger.infoln("Sets included in the consensus tree");
                    logger.infoln(" ");
                    int numTaxa = consensus.getIdGroup().getIdCount();
                    logger.infoln(consensus.getSetsIncluded());
                    logger.infoln(" ");
                    logger.infoln("Sets NOT included in consensus tree");
                    logger.infoln(" ");
                    logger.infoln(consensus.getSetsNotIncluded());
                    logger.infoln(" ");
                    logger.infoln("# # # # # # # # # # # # # # # #");
                    logger.infoln(" ");
                    Tree consensusTree = consensus.getConsensusTree();
                    String newickTree = treeFacade.toNewick(consensusTree, true, true, true);
                    logger.infoln(newickTree);
                    logger.infoln(" ");
                    logger.infoln("# # # # # # # # # # # # # # # #");
                    logger.infoln(" ");
                    logger.infoln(treeFacade.toASCII(consensusTree));
                    logger.infoln("");
                    logger.infoln(treeFacade.branchInfo(consensusTree));
                    logger.infoln("");
                    logger.infoln(treeFacade.heightInfo(consensusTree));
                }
            }
        }
        catch (ProtTestInternalException e) {
            logger.severeln(e.getMessage());
            ProtTest.finalize(-1);
        }
        catch (UnsupportedOperationException e) {
            logger.severeln(e.getMessage());
            ProtTest.finalize(-1);
        }
        ProtTest.finalize(0);
        if (MPJ_RUN) {
            MPI.Finalize();
        }
    }

    public static void finalize(int status) {
        if (status != 0 && MPJ_RUN) {
            MPI.COMM_WORLD.Abort(status);
        }
        if (MPJ_RUN) {
            MPI.Finalize();
        }
        System.exit(status);
    }
}

