/*
 * Decompiled with CFR 0.152.
 */
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqFormats;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.EmblDoc;
import iubio.readseq.Readseq;
import iubio.readseq.SeqFileInfo;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class mergedocseq {
    static String outformat = "embl";

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("Usage: jre -cp .:readseq.jar [out=output-file] [format=output-format] inputfile(s)");
        } else {
            try {
                Vector<String> names = new Vector<String>();
                PrintStream out = System.out;
                for (int iarg = 0; iarg < args.length; ++iarg) {
                    String arg = args[iarg];
                    if (arg.startsWith("format=")) {
                        outformat = arg.substring("format=".length());
                        continue;
                    }
                    if (arg.startsWith("out=")) {
                        String outfile = arg.substring("out=".length());
                        out = new PrintStream(new FileOutputStream(outfile));
                        continue;
                    }
                    names.addElement(arg);
                }
                BioseqWriterIface writer = BioseqFormats.newWriter(BioseqFormats.formatFromName(outformat));
                writer.setOutput(out);
                writer.writeHeader();
                Readseq rd = new Readseq();
                Enumeration en = names.elements();
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    String seqname = rd.setInputObject(name);
                    String docname = name + ".doc";
                    System.err.println("Merging " + docname + " with " + seqname);
                    if (!rd.isKnownFormat() || !rd.readInit()) continue;
                    while (rd.readNext()) {
                        SeqFileInfo sfi = rd.nextSeq();
                        sfi.seqdoc = mergedocseq.parseDoc(new EmblDoc(), docname);
                        if (writer.setSeq(sfi)) {
                            writer.writeSeqRecord();
                            continue;
                        }
                        System.err.println("Failed to write " + sfi);
                    }
                }
                writer.writeTrailer();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static BioseqDoc parseDoc(BioseqDoc doc, String docfile) throws Exception {
        String line;
        BufferedReader docf = new BufferedReader(new FileReader(docfile));
        while ((line = docf.readLine()) != null) {
            doc.addDocLine(line);
        }
        docf.close();
        return doc;
    }
}

