/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.AppResources;
import flybase.Args;
import flybase.Debug;
import flybase.Environ;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.BioseqFormats;
import iubio.readseq.Readseq;
import iubio.readseq.app;
import iubio.readseq.help;
import iubio.readseq.run;
import java.io.PrintStream;
import java.net.URL;

public class cgi
extends run {
    static final int kHelpdoc = 0;
    static final int kConvertForm = 1;
    static final int kMoreHelpdoc = 2;
    public static String formpath = "rez";
    public static String kCgiForm = "cgiform.html";
    public static String varkey = "%%";
    public static String docbaseUrlKey = "docbaseURL";
    static final int kNofeature = 0;
    static final int kSelfeature = 1;
    static final int kRemfeature = 2;
    int featsel = 0;
    int printdocKind = 1;
    boolean bIsHttpCall = true;
    boolean wantHelp;
    boolean moreHelp;
    boolean haveData;
    PrintStream pr = System.out;

    public static void main(String[] args) {
        new cgi(args);
    }

    protected void message(String s) {
        System.out.println(s);
    }

    public cgi(String[] args) {
        this.getargs(args);
        if (Environ.gEnv.isdefined("REQUEST_URI")) {
            Environ.gEnv.set("ReadseqForm.ACTION", Environ.gEnv.get("REQUEST_URI"));
        }
        if (this.haveInputData()) {
            this.verbose = false;
            this.outname = null;
            this.dopipe = true;
            switch (this.featsel) {
                default: {
                    this.featlist = null;
                    this.nofeatlist = null;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.nofeatlist = this.featlist;
                    this.featlist = null;
                }
            }
            int outid = BioseqFormats.getFormatId(this.outformat);
            String fn = Environ.gEnv.get("CONTENT_FILENAME");
            if (fn.length() == 0) {
                fn = "readseq-output";
            }
            fn = fn + BioseqFormats.formatSuffix(outid);
            this.pr.println("Window-target: " + fn);
            this.pr.println("Title: " + fn);
            String ct = Environ.gEnv.get("APP_CONTENT_TYPE");
            if (ct.indexOf(47) < 0) {
                ct = BioseqFormats.contentType(outid);
            }
            this.pr.println("Content-Type: " + ct);
            this.pr.println();
            this.run();
        } else {
            this.printhtmldoc(this.printdocKind);
        }
    }

    public static void cgiusage() {
        cgi.cgiusage(System.out);
    }

    public static void cgiusage(PrintStream out) {
        out.println();
        out.println("  HTTP server common gateway interface to Readseq");
        out.println("  Usage (example as cgi on unix system):");
        out.println("  Install shell script like this as '/cgi-bin/readseq.cgi' for your web server");
        out.println("    #!/bin/sh");
        out.println("    envtemp=/tmp/rseq$$.env");
        out.println("    env > ${envtemp}");
        out.println("    /usr/java/bin/jre -cp readseq.jar " + cgi.class.getName() + " env=${envtemp}");
        out.println("    /bin/rm ${envtemp}");
        out.println();
        out.println("  " + Readseq.version);
        out.println("  See also " + run.class.getName() + ".usage()");
        out.println();
    }

    public void printReadseqCgiUsage() {
        String helps = AppResources.global.getData(kReadseqcHelp);
        if (helps != null) {
            String lf = System.getProperty("line.separator");
            int e = helps.indexOf("</HTML");
            if (e > 0) {
                e = helps.lastIndexOf(lf, e);
            }
            if (e < 0) {
                e = helps.length();
            }
            this.pr.println(helps.substring(0, e));
            this.pr.println("</PRE>");
        }
        this.pr.println("<HR>");
        this.pr.println("<P><I><B>" + Readseq.version + "</B></I></P>");
        String url = Environ.gEnv.get("APP_SOURCE_URL");
        if (url.length() > 0) {
            this.pr.println("<P>Home of this package is ");
            this.pr.println("<A href=\"" + url + "\">" + url + "</A></P>");
        }
        if ((url = Environ.gEnv.get("APP_CGI_URL")).length() > 0) {
            this.pr.println("<P>An instance of the Web form for this is ");
            this.pr.println("<A href=\"" + url + "\">" + url + "</A></P>");
        }
        if ((url = Environ.gEnv.get("FEATURE_TABLE_URL")).length() > 0) {
            this.pr.println("<P>For further information on feature tables, see ");
            this.pr.println("<A href=\"" + url + "\">" + url + "</A></P>");
        }
        this.pr.println("<HR>");
        this.pr.println("<B>Known biosequence formats:</B><BR>");
        this.pr.println(BioseqFormats.getInfo(0, "html-header"));
        for (int i = 1; i <= BioseqFormats.nFormats(); ++i) {
            this.pr.println(BioseqFormats.getInfo(i, "html-command-line"));
        }
        this.pr.println(BioseqFormats.getInfo(0, "html-footer"));
        this.pr.println("&nbsp;&nbsp; (Int'leaf = interleaved format; Features = documentation/features are parsed)");
        this.pr.println("<HR>");
        this.pr.println("<P>Also available in this package:</P>");
        this.pr.println("<P>For the current help document, use <BR>jre -cp readseq.jar help</P>");
        this.pr.println("<PRE>");
        app.appusage(this.pr);
        this.pr.println("<HR>");
        cgi.cgiusage(this.pr);
        this.pr.println("</PRE>");
        this.pr.println("</BODY></HTML>");
    }

    public void getargs(String[] sargs) {
        this.doclassic = false;
        this.argv = new Args(sargs, this.bIsHttpCall);
        this.getargs();
    }

    protected void getOneArg() {
        boolean boolval;
        String argstr = this.argv.arg();
        String key = this.argv.argKey();
        String val = this.argv.argValue();
        boolean hasval = this.argv.hasValue();
        boolean bl = boolval = this.argv.isBoolean() ? this.argv.booleanValue() : true;
        if (key.equals("mimetype") || key.equals("mime")) {
            if (hasval) {
                Environ.gEnv.set("format", val);
                this.outformat = val;
            }
        } else if (key.equals("server")) {
            if (hasval) {
                Environ.gEnv.set("SERVER_PATH", val);
            }
        } else if (key.equalsIgnoreCase("APP_CONTENT_TYPE") || key.equalsIgnoreCase("contenttype")) {
            if (hasval) {
                Environ.gEnv.set("APP_CONTENT_TYPE", val);
            }
        } else if (argstr.startsWith(kInputStringKey)) {
            this.innames.addElement(argstr);
        } else if (key.equals("FILE_DATA")) {
            if (hasval && val.trim().length() > 0) {
                this.innames.addElement(kInputStringKey + val);
            }
        } else if (key.equals("STRING_DATA")) {
            if (hasval && val.trim().length() > 0) {
                this.innames.addElement(kInputStringKey + val);
            }
        } else if (key.equals("case")) {
            if ("lc".equals(val)) {
                this.dolowercase = true;
            } else if ("UC".equals(val)) {
                this.douppercase = true;
            } else if ("nc".equals(val)) {
                this.douppercase = false;
                this.dolowercase = false;
            }
        } else if (key.equals("featlist")) {
            if (hasval) {
                this.featlist = this.appends(this.featlist, val);
            }
        } else if (key.equals("featsel")) {
            this.featsel = this.argv.intValue();
        } else if (!key.equals("doall")) {
            if ("morehelp".equals(key)) {
                this.printdocKind = 2;
            } else if ("help".equals(key) || "h".equals(key)) {
                this.printdocKind = 0;
            } else if (key.startsWith("degap")) {
                this.degap = boolval;
            } else if (key.startsWith("gapch")) {
                if (hasval) {
                    this.degapc = val.charAt(0);
                }
            } else {
                super.getOneArg();
            }
        }
    }

    protected void handleUnknownArg() {
        Environ.gEnv.set(this.argv.argKey(), this.argv.argValue());
    }

    String getFormatChoice(String param) {
        boolean isout = !param.startsWith("in");
        StringBuffer sb = new StringBuffer();
        sb.append("<SELECT name=\"" + param + "\">\n");
        String selname = BioseqFormats.formatName(BioseqFormats.getFormatId(this.outformat));
        int n = BioseqFormats.nFormats();
        for (int i = 1; i <= n; ++i) {
            boolean cando = isout ? BioseqFormats.canwrite(i) : BioseqFormats.canread(i);
            if (!cando) continue;
            String ct = BioseqFormats.contentType(i);
            String nm = BioseqFormats.formatName(i);
            String sel = selname.equals(nm) ? "SELECTED " : "";
            sb.append("<OPTION " + sel + "value=\"" + ct + "\">" + nm);
            sb.append('\n');
        }
        sb.append("</SELECT>\n");
        return sb.toString();
    }

    String getFeaturesChoice(String param) {
        StringBuffer sb = new StringBuffer();
        sb.append("<SELECT name=\"" + param + "\" size=10 multiple>\n");
        String[] flist = BioseqDocImpl.getStandardFeatureList();
        if (flist == null) {
            flist = new String[]{"exon", "intron", "CDS"};
        }
        for (String nm : flist) {
            sb.append("<OPTION>" + nm);
            sb.append('\n');
        }
        sb.append("</SELECT>\n");
        return sb.toString();
    }

    public URL getHttpServerUrl() {
        URL su;
        block2: {
            su = null;
            try {
                String host = Environ.gEnv.get("SERVER_NAME");
                int port = Environ.gEnv.getInt("SERVER_PORT", 80);
                su = port == 80 || port == 0 ? new URL("http", host, "") : new URL("http", host, port, "");
            }
            catch (Exception e) {
                if (!Debug.isOn) break block2;
                e.printStackTrace();
            }
        }
        Debug.println("getHttpServerUrl=" + su);
        return su;
    }

    void printhtmldoc(int whichdoc) {
        this.pr.println("Content-Type: text/html");
        this.pr.println();
        switch (whichdoc) {
            default: {
                this.printReadseqCgiUsage();
                break;
            }
            case 2: {
                help h = new help(false, true, this.pr);
                h.extraHelp();
                break;
            }
            case 1: {
                String form = AppResources.global.getData(formpath, kCgiForm);
                if (form != null) {
                    Environ.gEnv.set("ReadseqForm.Outformat", this.getFormatChoice("format"));
                    Environ.gEnv.set("ReadseqForm.Features", this.getFeaturesChoice("featlist"));
                    this.printWithEnvVars(this.pr, form);
                    break;
                }
                this.pr.println("Error: missing form data <BR>");
            }
        }
    }

    public final void printWithEnvVars(PrintStream pr, String val) {
        this.printWithEnvVars(pr, val, null);
    }

    public void printWithEnvVars(PrintStream pr, String val, String data) {
        int lastend = 0;
        int at = 0;
        int keylen = varkey.length();
        while (at >= 0) {
            int at0 = at;
            if ((at = val.indexOf(varkey, at0)) < 0) continue;
            int e = val.indexOf(varkey, at + keylen);
            if (e > at) {
                pr.print(val.substring(at0, at));
                String key2 = val.substring(at + keylen, e);
                String val2 = Environ.gEnv.get(key2);
                pr.print(val2);
                lastend = e += keylen;
            }
            at = e;
        }
        pr.print(val.substring(lastend));
    }
}

