/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqWriter;
import java.io.IOException;

class PirSeqWriter
extends BioseqWriter {
    PirSeqWriter() {
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.opts.numwidth = 7;
        this.opts.seqwidth = 30;
        this.opts.spacer = -9;
        this.opts.numleft = true;
    }

    public void writeHeader() throws IOException {
        super.writeHeader();
        this.writeln("\\\\\\");
    }

    public void writeRecordEnd() {
        this.writeln("///");
    }

    public void writeDoc() {
        int j;
        String t;
        this.writeString("ENTRY           ");
        this.writeString(this.idword);
        this.writeln(" ");
        this.writeString("TITLE           ");
        String title = this.seqid;
        if (this.seqdoc instanceof BioseqDoc && (t = ((BioseqDoc)this.seqdoc).getTitle()) != null) {
            title = t;
        }
        this.writeString(title);
        this.writeString(" ");
        this.writeString(String.valueOf(this.seqlen));
        this.writeString(" bases  ");
        this.writeln(this.checksumString());
        this.writeln("SEQUENCE        ");
        for (j = 0; j < this.opts.numwidth; ++j) {
            this.writeByte(32);
        }
        for (j = 5; j <= this.opts.seqwidth; j += 5) {
            this.writeString(Fmt.fmt(j, 10));
        }
        this.writeln();
    }
}

