/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.Debug;
import flybase.OpenString;
import iubio.bioseq.SeqInfo;
import iubio.readseq.BioseqFormat;
import iubio.readseq.BioseqReaderIface;
import iubio.readseq.BioseqWriterIface;
import iubio.readseq.NumSppBases;
import iubio.readseq.Phylip2SeqReader;
import iubio.readseq.PhylipSeqReader;
import iubio.readseq.PhylipSeqWriter;

public class PhylipSeqFormat
extends BioseqFormat {
    protected SeqInfo seqkind = SeqInfo.getSeqInfo(99999, false, false);
    protected boolean formatDetermined;
    protected boolean interleaved = true;
    protected int isleaf;
    protected int isseq;
    protected NumSppBases nsppb = new NumSppBases();

    public String formatName() {
        this.getsubformat();
        if (this.interleaved) {
            return "Phylip|Phylip4";
        }
        return "Phylip3.2|Phylip2";
    }

    public String formatSuffix() {
        return ".phylip";
    }

    public String contentType() {
        return "biosequence/phylip";
    }

    public boolean canread() {
        return true;
    }

    public boolean canwrite() {
        return true;
    }

    public boolean interleaved() {
        this.getsubformat();
        return this.interleaved;
    }

    public boolean needsamelength() {
        return true;
    }

    public BioseqWriterIface newWriter() {
        this.getsubformat();
        PhylipSeqWriter c = new PhylipSeqWriter();
        c.setinterleaved(this.interleaved);
        return c;
    }

    public BioseqReaderIface newReader() {
        this.getsubformat();
        PhylipSeqReader c = this.interleaved ? new PhylipSeqReader() : new Phylip2SeqReader();
        return c;
    }

    protected void getsubformat() {
        if (!this.formatDetermined) {
            this.interleaved = this.isleaf > this.isseq ? true : this.isleaf >= this.isseq;
            this.formatDetermined = true;
        }
    }

    public void formatTestInit() {
        super.formatTestInit();
        this.isseq = 0;
        this.isleaf = 0;
        this.interleaved = true;
        this.formatDetermined = false;
        this.nsppb.init();
    }

    public boolean formatTestLine(OpenString sp, int atline, int skiplines) {
        if ((atline -= skiplines) == 1) {
            this.nsppb = PhylipSeqFormat.readSpeciesLength(sp);
            if (this.nsppb.good) {
                this.formatLikelihood += 15;
            }
        } else if (atline == 2 && this.nsppb.good && sp.length() > 10) {
            this.seqkind.add(sp.getValue(), sp.getOffset() + 10, sp.length() - 10);
            int tseq = this.seqkind.getKind();
            if (Character.isLetter(sp.charAt(0)) && tseq != 0) {
                this.formatLikelihood += 80;
                this.formatDetermined = false;
            }
        } else if (atline > 2 && this.nsppb.good) {
            int j;
            for (j = 0; Character.isWhitespace(sp.charAt(j)) && j < 10; ++j) {
            }
            if (atline - 1 <= this.speciesCount()) {
                if (j < 9) {
                    ++this.isleaf;
                } else {
                    ++this.isseq;
                }
            } else if (j >= 9) {
                ++this.isleaf;
            } else {
                ++this.isseq;
            }
        }
        return false;
    }

    public final int speciesCount() {
        return this.nsppb.nospp;
    }

    public final int sequenceLength() {
        return this.nsppb.baselen;
    }

    public static NumSppBases readSpeciesLength(OpenString sp) {
        int j;
        int i;
        int nospp = 0;
        int baselen = 0;
        int n = sp.length();
        for (i = 0; i < n && Character.isWhitespace(sp.charAt(i)); ++i) {
        }
        for (j = i; j < n && Character.isDigit(sp.charAt(j)); ++j) {
        }
        try {
            if (i < n) {
                nospp = Integer.parseInt(sp.substring(i, j).toString());
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (nospp > 0) {
            for (i = j + 1; i < n && Character.isWhitespace(sp.charAt(i)); ++i) {
            }
            for (j = i; j < n && Character.isDigit(sp.charAt(j)); ++j) {
            }
            try {
                if (i < n) {
                    baselen = Integer.parseInt(sp.substring(i, j).toString());
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (nospp > 0 && baselen > 0) {
            Debug.println("phylip nspp=" + nospp + ", nbase=" + baselen);
        }
        return new NumSppBases(nospp, baselen);
    }
}

