/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import iubio.readseq.InterleavedSeqWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

class MsfSeqWriter
extends InterleavedSeqWriter {
    protected String datestr;

    MsfSeqWriter() {
    }

    protected long calculateChecksum() {
        return MsfSeqWriter.GCGchecksum(this.bioseq, this.offset, this.seqlen);
    }

    protected void interleaf(int leaf) {
        if (leaf == 0) {
            this.writeln("//");
        }
        this.writeln();
    }

    protected void interleaveHeader() {
        String stype;
        int checktotal = 0;
        if (this.datestr == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy  HH:mm");
            this.datestr = sdf.format(new Date());
        }
        if (this.bioseq.getSeqtype() == 4) {
            stype = "P";
            this.writeString("!!AA");
        } else {
            stype = "N";
            this.writeString("!!NA");
        }
        this.writeln("_MULTIPLE_ALIGNMENT");
        this.writeln();
        this.writeString(" " + this.seqid + "  MSF: " + this.seqlen);
        this.writeString("  Type: " + stype + "  " + this.datestr);
        this.writeln("  Check: " + checktotal + " ..");
        this.writeln();
    }

    public void writeRecordStart() {
        super.writeRecordStart();
        this.setChecksum(true);
        this.opts.spacer = 10;
        this.opts.nameleft = true;
        this.opts.namewidth = 15;
        this.opts.seqwidth = 50;
        this.opts.tab = 1;
    }

    public void writeDoc() {
        super.writeDoc();
        this.writeString(" Name: " + Fmt.fmt(this.idword, 16, 2));
        this.writeString(" Len:" + Fmt.fmt(this.seqlen, 6));
        this.writeString("  Check:" + Fmt.fmt(this.checksum, 5));
        this.writeln("  Weight:  1.00");
    }
}

