/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.FastHashtable;
import flybase.FastProperties;
import iubio.readseq.BioseqDoc;
import iubio.readseq.BioseqDocImpl;
import iubio.readseq.DocItem;
import java.util.StringTokenizer;

public class EmblDoc
extends BioseqDocImpl {
    public static String emblprop = "EmblDoc";
    private static FastHashtable elabel2keys = new FastHashtable();
    private static FastProperties keys2elabel = new FastProperties();
    protected static String fFeatureTag;
    protected int fFeatIndent = 21;
    protected int fFieldIndent = 5;
    protected int gotOneFT;
    protected boolean isAmino;
    int lastkind;

    public EmblDoc() {
        this.eminit();
    }

    public EmblDoc(BioseqDoc source) {
        super(source);
        this.eminit();
        this.fFromForeignFormat = !(source instanceof EmblDoc);
    }

    public EmblDoc(String idname) {
        this.eminit();
        this.addBasicName(idname);
    }

    public void setAmino(boolean turnon) {
        this.isAmino = turnon;
    }

    protected void eminit() {
        this.kLinewidth = 80;
    }

    public void setSourceDoc(BioseqDoc source) {
        super.setSourceDoc(source);
        this.fFromForeignFormat = !(source instanceof EmblDoc);
    }

    public void addDocLine(String line) {
        String value;
        String field;
        int at;
        boolean append = false;
        int level = 1;
        int len = line.length();
        if (at < 0) {
            if (line.startsWith("XX")) {
                return;
            }
            line = line.trim();
            len = line.length();
            field = line;
            value = "";
            switch (this.inFeatures) {
                case 0: {
                    if (!field.equals(fFeatureTag)) break;
                    this.inFeatures = 2;
                    break;
                }
                case 2: {
                    if (field.equals(fFeatureTag)) {
                        return;
                    }
                    this.inFeatures = 3;
                }
            }
            if (this.inFeatures != 2) {
                if (field.equals(this.lastfld)) {
                    level = 3;
                    append = true;
                } else {
                    level = 1;
                }
            } else {
                level = 4;
            }
        } else {
            field = line.substring(0, at);
            for (at = line.indexOf(32); at < len && line.charAt(at) == ' '; ++at) {
            }
            switch (this.inFeatures) {
                case 0: {
                    if (!field.equals(fFeatureTag)) break;
                    this.inFeatures = 2;
                    break;
                }
                case 2: {
                    if (field.equals(fFeatureTag)) break;
                    this.inFeatures = 3;
                }
            }
            if (this.inFeatures != 2) {
                if (field.equals(this.lastfld)) {
                    level = 3;
                    append = true;
                } else {
                    level = 1;
                }
            } else if (at < this.fFeatIndent) {
                int e;
                level = 4;
                len = line.length();
                for (e = at; e < len && line.charAt(e) != ' ' && e < this.fFeatIndent; ++e) {
                }
                field = line.substring(at, e);
                for (at = e; at < len && line.charAt(at) == ' ' && at < this.fFeatIndent; ++at) {
                }
            } else {
                if (this.lastlev == 4 && line.charAt(at) != '/') {
                    level = 4;
                    append = true;
                } else {
                    level = 5;
                }
                field = this.lastfld;
            }
            value = line.substring(at).trim();
        }
        if (this.inFeatures == 2) {
            this.addFeature(field, value, level, append);
        } else {
            this.addDocField(field, value, level, append);
        }
        if (level != 3) {
            this.lastfld = field;
            this.lastlev = level;
        }
    }

    protected int addlinefield(String val, int vallen, int at, String scanto, String fldname, int fldkind, int fldlev) {
        String sv;
        if (at > vallen) {
            return -1;
        }
        int e = val.indexOf(scanto, at);
        if (e < 0) {
            e = vallen;
        }
        if ((sv = val.substring(at, e).trim()).length() > 0) {
            super.addDocField(fldname, sv, fldkind, fldlev, false);
        }
        return e + scanto.length();
    }

    protected void addIdline(String field, String val) {
        int cir;
        int vlen = val.length();
        int at = this.addlinefield(val, vlen, 0, " ", field, 10, 1);
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, "; ", "dataclass", 12, 1);
        }
        if (at > 0 && (cir = val.indexOf("circular", at)) > 0) {
            super.addDocField("circ", "circular", 115, 1, false);
            at = cir + "circular".length();
        }
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, "; ", "mol", 113, 1);
        }
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, "; ", "div", 11, 1);
        }
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, " BP", "length", 112, 1);
        }
    }

    protected String getIdValue(DocItem di) {
        StringBuffer sb = new StringBuffer();
        this.putlinefield(sb, Fmt.fmt(di.getValue(), 9, 2) + " ", "Noname", " ");
        this.putlinefield(sb, this.getDocField(12), "standard", "; ");
        String sv = this.getDocField(115);
        if (sv != null) {
            sb.append(sv);
            sb.append(' ');
        }
        this.putlinefield(sb, this.getDocField(113), "DNA", "; ");
        this.putlinefield(sb, this.getDocField(11), "UNC", "; ");
        this.putlinefield(sb, this.getDocField(112), "0", " BP.");
        return sb.toString();
    }

    protected void addSeqstats(String field, String val) {
        int vlen = val.length();
        super.addDocField(field, "", 110, 1, false);
        int at = val.indexOf("BP;") + 4;
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, " A;", "na", 117, 2);
        }
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, " C;", "nc", 118, 2);
        }
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, " G;", "ng", 119, 2);
        }
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, " T;", "nt", 120, 2);
        }
        if (at > 0) {
            at = this.addlinefield(val, vlen, at, " other", "nn", 121, 2);
        }
    }

    protected String getSequenceValue(DocItem di) {
        StringBuffer sb = new StringBuffer("Sequence ");
        this.putlinefield(sb, this.getDocField(112), "0", " BP; ");
        this.putlinefield(sb, this.getDocField(117), "0", " A; ");
        this.putlinefield(sb, this.getDocField(118), "0", " C; ");
        this.putlinefield(sb, this.getDocField(119), "0", " G; ");
        this.putlinefield(sb, this.getDocField(120), "0", " T; ");
        this.putlinefield(sb, this.getDocField(121), "0", " other;");
        return sb.toString();
    }

    public void addDocField(String field, String val, int level, boolean append) {
        int kind = 0;
        if (level == 1 || level == 2 || level == 3) {
            kind = this.getBiodocKind(field);
            switch (kind) {
                case 10: {
                    this.addIdline(field, val);
                    return;
                }
                case 110: {
                    this.addSeqstats(field, val);
                    return;
                }
                case 60: {
                    int a = val.indexOf(91);
                    int e = val.indexOf(93);
                    if (a < 0 || e <= a) break;
                    val = val.substring(a + 1, e);
                    break;
                }
                case 80: 
                case 90: {
                    level = 1;
                    append = false;
                    break;
                }
                case 62: {
                    if (level == 1) {
                        level = 2;
                    }
                    if (val.startsWith("\"")) {
                        val = val.substring(1);
                    }
                    int vlen = val.length();
                    if (val.endsWith("\";")) {
                        val = val.substring(0, vlen - 2);
                        break;
                    }
                    if (!val.endsWith(";")) break;
                    val = val.substring(0, vlen - 1);
                    break;
                }
                case 51: 
                case 61: 
                case 63: 
                case 64: 
                case 65: {
                    if (level != 1) break;
                    level = 2;
                    break;
                }
                case 30: {
                    val = val.replace(';', ' ').trim();
                }
            }
        }
        super.addDocField(field, val, kind, level, append);
    }

    protected void writeDocItem(DocItem nv, boolean writeAll) {
        int kind = nv.getKind();
        switch (kind) {
            case 1: 
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 112: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                break;
            }
            case 114: {
                if (this.isAmino) break;
                super.writeDocItem(new DocItem(this.getFieldName(100), nv.getValue() + " CRC32;", 100, 1), writeAll);
                break;
            }
            case 110: {
                this.lastkind = kind;
                if (!this.isAmino) {
                    this.pr.println("XX");
                }
                this.writeKeyValue(nv);
                break;
            }
            default: {
                if (!this.isAmino && kind != this.lastkind && kind != 10 && kind != 111 && nv.getLevel() == 1) {
                    this.pr.println("XX");
                }
                this.lastkind = kind;
                super.writeDocItem(nv, writeAll);
            }
        }
    }

    protected void putlinefield(StringBuffer sb, String sv, String defval, String tail) {
        sb.append(sv == null ? defval : sv);
        sb.append(tail);
    }

    protected String getFieldValue(DocItem di) {
        switch (di.getKind()) {
            case 70: {
                if (this.isAmino) {
                    return "";
                }
                return "Key             Location/Qualifiers";
            }
            case 10: {
                return this.getIdValue(di);
            }
            case 110: {
                return this.getSequenceValue(di);
            }
            case 60: {
                String rn = di.getValue();
                return "[" + rn + "]";
            }
            case 30: {
                String val = di.getValue();
                if (val.indexOf(32) > 0) {
                    StringBuffer sb = new StringBuffer();
                    StringTokenizer st = new StringTokenizer(val, " ");
                    while (st.hasMoreTokens()) {
                        sb.append(st.nextToken());
                        sb.append("; ");
                    }
                    val = sb.toString();
                }
                return val + ";";
            }
            case 62: {
                String val = di.getValue();
                if (val.length() > 1 && !val.endsWith("\";")) {
                    val = "\"" + val + "\";";
                }
                return val;
            }
        }
        return super.getFieldValue(di);
    }

    protected String getFieldLabel(int level, DocItem di) {
        String name = null;
        this.indent = 0;
        this.subindent = 0;
        switch (level) {
            default: {
                name = this.fFromForeignFormat ? this.getFieldName(di.getKind()) : di.getName();
                if (name == null || name.length() == 0) {
                    return null;
                }
                this.indent = this.fFieldIndent;
                return Fmt.fmt(name, this.indent - 1, 2) + " ";
            }
            case 4: {
                this.indent = this.fFeatIndent;
                return "FT" + this.spaces(this.fFieldIndent - 2) + Fmt.fmt(di.getName(), this.indent - this.fFieldIndent - 1, 2) + " ";
            }
            case 5: {
                name = di.getName();
                if (!name.startsWith("/")) {
                    name = "/" + name;
                }
                if (di.hasValue()) {
                    name = name + "=";
                }
                this.subindent = name.length();
                this.indent = this.fFeatIndent;
                return "FT" + this.spaces(this.indent - 2) + name;
            }
            case 6: 
        }
        this.indent = this.fFeatIndent;
        return Fmt.fmt("FT", this.indent, 2);
    }

    public String getBiodockey(String field) {
        return (String)elabel2keys.get(field);
    }

    public String getFieldName(int kind) {
        this.indent = this.fFieldIndent;
        String lab = null;
        String biodockey = EmblDoc.getBiodockey(kind);
        if (biodockey != null) {
            lab = (String)keys2elabel.get(biodockey);
        }
        switch (kind) {
            case 70: {
                ++this.gotOneFT;
                this.indent = this.fFeatIndent;
                break;
            }
            case 71: 
            case 72: {
                this.indent = this.fFeatIndent;
            }
        }
        return lab;
    }

    static {
        String pname = System.getProperty(emblprop, emblprop);
        EmblDoc.getDocProperties(pname, keys2elabel, elabel2keys);
        fFeatureTag = "FT";
    }
}

