/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import flybase.FastHashtable;
import flybase.OpenString;
import iubio.bioseq.BaseKind;
import iubio.readseq.BioseqReader;
import java.io.IOException;

class BlastOutputReader
extends BioseqReader {
    protected char matchchar = '\u0000';
    protected final int kMinSeqline = 30;
    protected boolean firstSeqline;
    protected boolean atname;
    protected boolean domatch;
    protected boolean done;
    protected OpenString saveseq;
    protected String sid1;
    protected int atbase;
    protected int alignmentLine;
    protected int iline;
    protected int seqindent;
    protected int seqendindent;
    protected FastHashtable idhash = new FastHashtable();
    static final int kEndOfSequence = -1;
    static final int kSkipLine = 0;
    static final int kSequenceLine = 1;

    public BlastOutputReader() {
        this.margin = 0;
        this.addfirst = false;
        this.addend = false;
        this.ungetend = true;
    }

    protected void read() throws IOException {
        if (this.alignmentLine == 0) {
            this.alignmentLine = this.findAlignments();
        }
        if (this.alignmentLine < 0) {
            return;
        }
        this.readAlignments();
    }

    public void skipPastHeader(int skiplines) {
        super.skipPastHeader(skiplines);
        try {
            if (this.alignmentLine > 0) {
                for (int i = this.alignmentLine - 1; i > 0; --i) {
                    this.getline();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected int findAlignments() throws IOException {
        int aline = 0;
        while (!this.endOfFile()) {
            char c;
            int e;
            this.getline();
            ++aline;
            int at = this.sWaiting.indexOf(32);
            if (at <= 0) continue;
            int len = this.nWaiting;
            boolean haveSeqChar = false;
            boolean maybeSeqLine = true;
            while (!haveSeqChar && maybeSeqLine) {
                if (++at >= len) {
                    maybeSeqLine = false;
                    continue;
                }
                char c2 = this.sWaiting.charAt(at);
                if (c2 <= ' ') continue;
                if (BaseKind.isAlphaseq(c2)) {
                    haveSeqChar = true;
                    continue;
                }
                if (BaseKind.isIndel(c2) || c2 >= '0' && c2 <= '9') continue;
                maybeSeqLine = false;
            }
            if (!haveSeqChar) continue;
            for (e = at; e < len && (c = this.sWaiting.charAt(e)) > ' '; ++e) {
                if (BaseKind.isAlphaseq(c) || BaseKind.isIndel(c)) continue;
                maybeSeqLine = false;
                break;
            }
            if (!maybeSeqLine || e <= at + 30) continue;
            this.seqindent = at;
            this.seqendindent = e;
            return aline;
        }
        return -1;
    }

    public boolean endOfSequence() {
        return this.isSequenceLine() == -1;
    }

    protected int isSequenceLine() {
        if (this.nWaiting == 0) {
            return 0;
        }
        char c = this.sWaiting.charAt(0);
        if (Character.isLetterOrDigit(c)) {
            if (this.nWaiting > this.seqindent) {
                return 1;
            }
            return -1;
        }
        if (c == ' ') {
            int at;
            for (at = 0; at < this.nWaiting && this.sWaiting.charAt(at) <= ' '; ++at) {
            }
            if (at == this.nWaiting) {
                return 0;
            }
            if (at < this.seqindent) {
                return -1;
            }
            return 0;
        }
        return 0;
    }

    protected void readAlignments() throws IOException {
        this.atname = true;
        this.firstSeqline = true;
        this.domatch = true;
        boolean bl = this.addit = this.choice > 0;
        if (this.addit) {
            this.seqlen = 0;
        }
        this.iline = 0;
        this.seqlencount = 0;
        this.atbase = 0;
        this.seqoffset = 0;
        this.readIndata();
        do {
            this.getline();
            this.done = this.endOfFile();
            if (this.done && this.nWaiting == 0) break;
            switch (this.isSequenceLine()) {
                case 0: {
                    break;
                }
                case -1: {
                    this.done = true;
                    break;
                }
                case 1: {
                    this.readIndata();
                }
            }
        } while (!this.done);
        this.nseq = this.idhash.size();
        this.setNseq(this.nseq);
        this.allDone = true;
    }

    protected void fixmatchchar(int offset) {
        if (this.matchchar == '\u0000') {
            int dots = 0;
            int dashes = 0;
            int len = this.nWaiting - offset;
            for (int i = 0; i < len; ++i) {
                char c = this.getreadbuf(offset + i);
                if (c == '.') {
                    ++dots;
                    continue;
                }
                if (c != '-') continue;
                ++dashes;
            }
            this.matchchar = dashes > dots ? (char)45 : (char)46;
        }
        for (int i = 0; i < this.saveseq.length(); ++i) {
            char c = this.getreadbuf(offset + i);
            if (c == ' ') {
                this.setreadbuf(offset + i, BaseKind.indelEdge);
                continue;
            }
            if (c != this.matchchar) continue;
            this.setreadbuf(offset + i, this.saveseq.charAt(i));
        }
    }

    protected void readIndata() {
        OpenString si = this.sWaiting;
        if (this.nWaiting > 0) {
            int seqat;
            int endname = si.indexOf(32);
            if (endname <= 0) {
                return;
            }
            String sid = si.substring(0, endname).trim().toString();
            if (this.idhash.get(sid) == null) {
                ++this.nseq;
                this.idhash.put(sid, new SeqIndex(this.nseq, this.seqoffset));
                if (this.choice == -1) {
                    this.addinfo(sid);
                }
            }
            SeqIndex sind = (SeqIndex)this.idhash.get(sid);
            this.atseq = sind.atseq;
            if (this.atseq == this.choice) {
                this.seqid = sid;
            }
            if (this.atseq == 1) {
                this.sid1 = sid;
            }
            if ((seqat = this.seqindent) >= this.nWaiting) {
                return;
            }
            int endseq = this.seqendindent;
            if (endseq >= this.nWaiting) {
                endseq = this.nWaiting;
            }
            boolean badc = true;
            while (badc && endseq > seqat) {
                char c = si.charAt(endseq - 1);
                if (c > ' ' && (BaseKind.isAlphaseq(c) || BaseKind.isIndel(c))) {
                    badc = false;
                    continue;
                }
                --endseq;
            }
            if (sid.equals(this.seqid)) {
                if (this.domatch) {
                    if (sid.equals(this.sid1)) {
                        this.saveseq = si.substring(seqat, endseq);
                    } else {
                        this.fixmatchchar(seqat);
                    }
                }
                if (this.firstSeqline && this.atseq != 1 && this.seqoffset > 0) {
                    this.setSeqoffset(this.seqoffset);
                }
                this.addseq(this.getreadchars(), this.getreadcharofs() + seqat, endseq - seqat);
                if (this.atseq == 1) {
                    this.seqoffset = this.atbase;
                    this.atbase = this.seqlen;
                }
                this.firstSeqline = false;
            } else if (sid.equals(this.sid1)) {
                if (this.domatch) {
                    this.saveseq = si.substring(seqat, endseq);
                }
                this.seqoffset = this.atbase;
                int bases = this.countseqline(this.getreadchars(), this.getreadcharofs() + seqat, endseq - seqat);
                this.atbase += bases;
            }
            ++this.iline;
        }
    }

    class SeqIndex {
        int atseq;
        int atbase;

        SeqIndex(int nseq, int nbase) {
            this.atseq = nseq;
            this.atbase = nbase;
        }
    }
}

