/*
 * Decompiled with CFR 0.152.
 */
package iubio.readseq;

import Acme.Fmt;
import flybase.AppResources;
import flybase.Debug;
import flybase.FastHashtable;
import flybase.FastProperties;
import flybase.FastVector;
import flybase.OpenString;
import iubio.bioseq.Bioseq;
import iubio.bioseq.SeqInfo;
import iubio.bioseq.SeqRange;
import iubio.readseq.BioseqDoc;
import iubio.readseq.DocItem;
import iubio.readseq.FeatureItem;
import iubio.readseq.FeatureNote;
import iubio.readseq.PrintableDocItem;
import iubio.readseq.XmlDoc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class BioseqDocImpl
implements BioseqDoc,
Cloneable {
    public static String bioseqprop = "BioseqDoc";
    public static String gbfeatname = "Features";
    public static final String sExtractionFeature = "extracted_range";
    public static final String sExtractRangeFeature = "extract_range";
    public static String sExtractionNote = "Range of sequence extracted from original.  Feature locations are for original, not for this sequence.";
    protected static FastHashtable biodockeys = new FastHashtable();
    protected static FastHashtable biodockinds = new FastHashtable();
    protected static FastHashtable biodoclabels = new FastHashtable();
    protected static String[] gbfeatures;
    protected static String[] gbqualifiers;
    protected FastVector rootdoc;
    protected FastVector featlist;
    protected Hashtable wantedFeatures;
    protected SeqRange wantedRange;
    protected boolean fFromForeignFormat;
    protected boolean featWrit;
    protected boolean dontWriteId;
    protected boolean notWantedFeature;
    protected boolean wantExtractionLoc;
    protected int docItemAt;
    protected DocItem curDocitem;
    protected FeatureItem curFieldItem;
    protected int lastlev = 1;
    protected boolean skipdocs;
    protected String lastfld;
    protected int inFeatures = 0;
    protected FastHashtable keepFields;
    protected int featStartItem;
    public int kLinewidth = 79;
    protected int indent;
    protected int subindent;
    protected int linesout;
    protected PrintWriter pr;
    protected String extractionNote = sExtractionNote;

    private static void getBioseqdocProperties() {
        BioseqDocImpl.putdocval("kUnknown", 0, "Other field");
        BioseqDocImpl.putdocval("kBioseqSet", 1, "Biosequence collection");
        BioseqDocImpl.putdocval("kBioseq", 2, "Biosequence record");
        BioseqDocImpl.putdocval("kBioseqDoc", 3, "Documentation");
        BioseqDocImpl.putdocval("kName", 10, "Locus name");
        BioseqDocImpl.putdocval("kDivision", 11, "Databank division");
        BioseqDocImpl.putdocval("kDataclass", 12, "Data class");
        BioseqDocImpl.putdocval("kDescription", 20, "Description");
        BioseqDocImpl.putdocval("kAccession", 30, "Accession");
        BioseqDocImpl.putdocval("kNid", 31, "NID (part id)");
        BioseqDocImpl.putdocval("kVersion", 32, "Version");
        BioseqDocImpl.putdocval("kKeywords", 40, "Keywords");
        BioseqDocImpl.putdocval("kSource", 50, "Organism source");
        BioseqDocImpl.putdocval("kTaxonomy", 51, "Organism taxonomy");
        BioseqDocImpl.putdocval("kReference", 60, "Reference number");
        BioseqDocImpl.putdocval("kAuthor", 61, "Reference author");
        BioseqDocImpl.putdocval("kTitle", 62, "Reference title");
        BioseqDocImpl.putdocval("kJournal", 63, "Reference journal");
        BioseqDocImpl.putdocval("kRefCrossref", 64, "Reference database ID (Medline)");
        BioseqDocImpl.putdocval("kRefSeqindex", 65, "Reference sequence index");
        BioseqDocImpl.putdocval("kFeatureTable", 70, "Feature table");
        BioseqDocImpl.putdocval("kFeatureItem", 71, "Feature item");
        BioseqDocImpl.putdocval("kFeatureNote", 72, "Feature note");
        BioseqDocImpl.putdocval("kFeatureKey", 73, "Feature name");
        BioseqDocImpl.putdocval("kFeatureValue", 74, "Feature value");
        BioseqDocImpl.putdocval("kFeatureLocation", 75, "Feature location");
        BioseqDocImpl.putdocval("kDate", 80, "Date");
        BioseqDocImpl.putdocval("kCrossRef", 90, "Database cross reference");
        BioseqDocImpl.putdocval("kComment", 100, "Comment ");
        BioseqDocImpl.putdocval("kSeqstats", 110, "Sequence statistics");
        BioseqDocImpl.putdocval("kNumA", 117, "No. A bases");
        BioseqDocImpl.putdocval("kNumC", 118, "No. C bases");
        BioseqDocImpl.putdocval("kNumG", 119, "No. G bases");
        BioseqDocImpl.putdocval("kNumT", 120, "No. T bases");
        BioseqDocImpl.putdocval("kNumN", 121, "No. other bases");
        BioseqDocImpl.putdocval("kSeqdata", 111, "Sequence data");
        BioseqDocImpl.putdocval("kSeqlen", 112, "Sequence length");
        BioseqDocImpl.putdocval("kSeqkind", 113, "Molecule kind");
        BioseqDocImpl.putdocval("kChecksum", 114, "Sequence checksum");
        BioseqDocImpl.putdocval("kSeqcircle", 115, "Circular sequence");
        BioseqDocImpl.putdocval("kStrand", 116, "Sequence strandedness");
        BioseqDocImpl.putdocval("kBlank", 200, "blank line");
    }

    private static void putdocval(String key, int val, String label) {
        Integer ival = new Integer(val);
        biodockeys.put(key, ival);
        biodockinds.put(ival, key);
        biodoclabels.put(ival, label);
    }

    public static String[] getStandardQualifiersList() {
        if (gbqualifiers == null) {
            BioseqDocImpl.getStandardFeatureList();
        }
        return gbqualifiers;
    }

    public static String[] getStandardFeatureList() {
        if (gbfeatures == null) {
            try {
                String s;
                String pname = System.getProperty(gbfeatname, gbfeatname);
                pname = AppResources.global.findPath(pname + ".properties");
                Debug.println("Feature list: " + pname);
                InputStream ins = AppResources.global.getStream(pname);
                DataInputStream rdr = new DataInputStream(new BufferedInputStream(ins));
                FastVector fv = new FastVector();
                FastVector qv = new FastVector();
                boolean inquals = false;
                do {
                    if ((s = rdr.readLine()) == null) continue;
                    if ((s = s.trim()).indexOf("FEATURES") > 0) {
                        inquals = false;
                        continue;
                    }
                    if (s.indexOf("QUALIFIERS") > 0) {
                        inquals = true;
                        continue;
                    }
                    if (s.length() <= 0 || s.startsWith("#")) continue;
                    if (inquals) {
                        qv.addElement(s);
                    } else {
                        fv.addElement(s);
                    }
                    Debug.print(s + ", ");
                } while (s != null);
                gbfeatures = new String[fv.size()];
                fv.copyInto(gbfeatures);
                gbqualifiers = new String[qv.size()];
                qv.copyInto(gbqualifiers);
                Debug.println();
                Debug.println(" n = " + fv.size());
                ins.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return gbfeatures;
    }

    public BioseqDocImpl() {
        this.rootdoc = new FastVector();
        this.featlist = new FastVector();
    }

    public BioseqDocImpl(BioseqDoc source) {
        this.setSourceDoc(source);
    }

    public abstract String getFieldName(int var1);

    public abstract String getBiodockey(String var1);

    public abstract void addDocLine(String var1);

    public void addDocLine(OpenString line) {
        this.addDocLine(line.toString());
    }

    public static String getBiodockey(int kind) {
        return (String)biodockinds.get(new Integer(kind));
    }

    public static String getBiodoclabel(int kind) {
        return (String)biodoclabels.get(new Integer(kind));
    }

    public Integer getBiodocInteger(String field) {
        String bdkey = this.getBiodockey(field);
        return bdkey == null ? null : (Integer)biodockeys.get(bdkey);
    }

    public int getBiodocKind(String field) {
        String bdkey = this.getBiodockey(field);
        if (bdkey == null) {
            return 0;
        }
        Integer ikind = (Integer)biodockeys.get(bdkey);
        if (ikind == null) {
            return 0;
        }
        return ikind;
    }

    protected static void getDocProperties(String propname, FastProperties keys2label, FastHashtable label2keys) {
        keys2label.loadProperties(propname);
        Enumeration en = keys2label.keys();
        while (en.hasMoreElements()) {
            String biodockey = (String)en.nextElement();
            String label = keys2label.getProperty(biodockey);
            label2keys.put(label, biodockey);
        }
    }

    public Object clone() {
        try {
            Object el;
            int i;
            BioseqDocImpl c = (BioseqDocImpl)super.clone();
            if (this.rootdoc != null) {
                c.rootdoc = (FastVector)this.rootdoc.clone();
                for (i = 0; i < this.rootdoc.size(); ++i) {
                    el = c.rootdoc.elementAt(i);
                    if (el instanceof DocItem) {
                        el = ((DocItem)el).clone();
                    }
                    c.rootdoc.setElementAt(el, i);
                }
            }
            if (this.wantedFeatures != null) {
                // empty if block
            }
            if (this.featlist != null) {
                c.featlist = (FastVector)this.featlist.clone();
                for (i = 0; i < c.featlist.size(); ++i) {
                    el = c.featlist.elementAt(i);
                    if (el instanceof DocItem) {
                        el = ((DocItem)el).clone();
                    }
                    c.featlist.setElementAt(el, i);
                }
            }
            return c;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error(ex.toString());
        }
    }

    public void clear() {
        if (this.rootdoc != null) {
            this.rootdoc.removeAllElements();
        }
        if (this.featlist != null) {
            this.featlist.removeAllElements();
        }
    }

    public String getID() {
        return this.getDocField(10);
    }

    public String getTitle() {
        return this.getDocField(20);
    }

    public boolean hasFeatures() {
        return this.featlist != null && this.featlist.size() > 0;
    }

    public boolean hasDocument() {
        return this.rootdoc != null && this.rootdoc.size() > 0;
    }

    public FastVector documents() {
        return this.rootdoc;
    }

    public FastVector features() {
        return this.featlist;
    }

    public void setSourceDoc(BioseqDoc source) {
        if (source == null) {
            this.rootdoc = new FastVector();
            this.featlist = new FastVector();
        } else {
            this.rootdoc = source.documents();
            this.featlist = source.features();
            if (source instanceof BioseqDocImpl) {
                this.copyWanted((BioseqDocImpl)source);
            }
            this.fFromForeignFormat = true;
        }
    }

    public final String getDocField(int kind) {
        DocItem di = this.findDocItem(this.rootdoc, kind, 0);
        if (di == null) {
            return null;
        }
        return di.getValue();
    }

    public final String getDocField(FastVector doc, int kind, int which) {
        DocItem di = this.findDocItem(doc, kind, which);
        if (di == null) {
            return null;
        }
        return di.getValue();
    }

    public void deleteDocItem(int kind) {
        DocItem di = this.findDocItem(this.rootdoc, kind, 0);
        if (di != null) {
            this.rootdoc.removeElement(di);
        }
    }

    public void deleteDocItem(FastVector doc, int kind, int which) {
        DocItem di = this.findDocItem(doc, kind, which);
        if (di != null) {
            doc.removeElement(di);
        }
    }

    public final void replaceDocItem(int kind, DocItem newitem) {
        if (newitem == null) {
            this.deleteDocItem(kind);
        } else {
            DocItem di = this.findDocItem(this.rootdoc, kind, 0);
            if (di != null && this.docItemAt > -1) {
                this.rootdoc.setElementAt(newitem, this.docItemAt);
            } else {
                this.addDocField(newitem);
            }
        }
    }

    public final DocItem findDocItem(int kind, int which) {
        return this.findDocItem(this.rootdoc, kind, which);
    }

    public DocItem findDocItem(FastVector doc, int kind, int which) {
        Object ob = null;
        this.docItemAt = -1;
        if (doc != null) {
            int count = 0;
            for (int i = 0; i < doc.size(); ++i) {
                try {
                    DocItem res;
                    ob = doc.elementAt(i);
                    if (ob instanceof DocItem) {
                        DocItem anv = (DocItem)ob;
                        if (anv.getKind() == kind) {
                            this.docItemAt = i;
                            if (count == which) {
                                return anv;
                            }
                            ++count;
                        }
                        continue;
                    }
                    if (!(ob instanceof FastVector) || (res = this.findDocItem((FastVector)ob, kind, which)) == null) continue;
                    return res;
                }
                catch (Exception e) {
                    System.err.println("failure in getDocField(" + kind + ") for object " + ob);
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public final String getDocField(String field) {
        return this.getDocField(field, 0);
    }

    public final String getFeature(String field) {
        return this.getDocField(this.features(), field, 0);
    }

    public final String getDocField(String field, int which) {
        DocItem di = this.findDocItem(this.rootdoc, field, which);
        if (di == null) {
            return null;
        }
        return di.getValue();
    }

    public final String getDocField(FastVector doc, String field, int which) {
        DocItem di = this.findDocItem(doc, field, which);
        if (di == null) {
            return null;
        }
        return di.getValue();
    }

    public DocItem findDocItem(FastVector doc, String field, int which) {
        if (doc != null) {
            int count = 0;
            for (int i = 0; i < doc.size(); ++i) {
                DocItem res;
                Object ob = doc.elementAt(i);
                if (ob instanceof DocItem) {
                    DocItem anv = (DocItem)ob;
                    if (!anv.sameName(field)) continue;
                    if (count == which) {
                        return anv;
                    }
                    ++count;
                    continue;
                }
                if (!(ob instanceof FastVector) || (res = this.findDocItem((FastVector)ob, field, which)) == null) continue;
                return res;
            }
        }
        return null;
    }

    public FeatureItem getCurFieldItem() {
        return this.curFieldItem;
    }

    public void setCurFieldItem(FeatureItem fi) {
        this.curFieldItem = fi;
    }

    public void setKeepField(int kind) {
        if (this.keepFields == null) {
            this.keepFields = new FastHashtable();
        }
        Integer ikind = new Integer(kind);
        this.keepFields.put(ikind, ikind);
    }

    protected boolean keepField(int kind) {
        return this.keepFields == null || this.keepFields.get(new Integer(kind)) != null;
    }

    public void setSkipDocs(boolean turnon) {
        this.skipdocs = turnon;
        if (turnon) {
            this.setKeepField(10);
            this.setKeepField(20);
            this.setKeepField(30);
            this.setKeepField(111);
        } else {
            this.keepFields = null;
        }
    }

    public void addBasicName(String desc) {
        int i;
        if (desc == null) {
            return;
        }
        if ((desc = desc.trim()).indexOf("checksum") > 0) {
            i = desc.indexOf("bases");
            if (i < 0) {
                i = desc.indexOf(" bp");
            }
            if (i > 0) {
                while (i > 0 && desc.charAt(i) != ',') {
                    --i;
                }
                if (i > 0) {
                    desc = desc.substring(0, i);
                }
            }
        }
        if ((i = desc.indexOf(32)) <= 0) {
            i = desc.length();
        }
        if (i > 30) {
            i = 30;
        }
        if (i == desc.length()) {
            this.replaceDocField(10, desc);
        } else {
            String idword = desc.substring(0, i);
            this.replaceDocField(10, idword);
            this.addDocField(20, desc);
        }
    }

    public void addComment(String comment) {
        this.addDocField(this.getFieldName(100), comment, 1, false);
    }

    public void addDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
        String datestr = sdf.format(date);
        this.addDocField(this.getFieldName(80), datestr, 1, false);
    }

    public void addSequenceStats(Bioseq seq) {
        SeqInfo si = seq.getSeqStats();
        this.replaceDocField(112, String.valueOf(seq.length()));
        this.replaceDocField(113, si.getKindLabel());
        int[] agctn = null;
        if (si.getKind() != 4) {
            agctn = si.getACGTcounts();
        }
        if (agctn != null) {
            this.replaceDocField(117, String.valueOf(agctn[0]));
            this.replaceDocField(118, String.valueOf(agctn[1]));
            this.replaceDocField(119, String.valueOf(agctn[2]));
            this.replaceDocField(120, String.valueOf(agctn[3]));
            this.replaceDocField(121, String.valueOf(agctn[4]));
        }
    }

    public void addDocText(String text) {
        this.inFeatures = 0;
        this.addText(text);
    }

    public void addFeatureText(String text) {
        this.inFeatures = 2;
        this.addText(text);
    }

    protected void addText(String text) {
        StringTokenizer st = new StringTokenizer(text, "\r\n");
        while (st.hasMoreTokens()) {
            this.addDocLine(st.nextToken());
        }
    }

    public void addDocField(DocItem di) {
        if (di != null) {
            this.curDocitem = di;
            this.rootdoc.addElement(di);
        }
    }

    public void addDocField(int fieldId, String value) {
        String field = this.getFieldName(fieldId);
        this.addDocField(field, value, fieldId, 1, false);
    }

    public void replaceDocField(int fieldId, String value) {
        String field = this.getFieldName(fieldId);
        DocItem di = new DocItem(field, value, fieldId, 1);
        this.replaceDocItem(fieldId, di);
    }

    public void addDocField(String field, String value, int level, boolean append) {
        int kind = this.getBiodocKind(field);
        this.addDocField(field, value, kind, level, append);
    }

    public void addDocField(String field, String value, int kind, int level, boolean append) {
        if (!this.keepField(kind)) {
            return;
        }
        if (append && this.curDocitem != null) {
            this.curDocitem.appendValue(value);
        } else {
            this.addDocField(new DocItem(field, value, kind, level));
            this.lastlev = level;
        }
    }

    public void addFeatureNote(FeatureItem featItem, String key, String value) {
        if (!key.startsWith("/")) {
            key = "/" + key;
        }
        FeatureNote note = new FeatureNote(key, value);
        if (featItem != null) {
            featItem.putNote(note);
        }
    }

    public void addFeatureNote(FeatureItem featItem, String value) {
        if (value != null) {
            String key;
            int at = value.indexOf(61);
            if (at < 0) {
                key = value;
                value = "";
            } else {
                key = value.substring(0, at);
                value = value.substring(at + 1);
            }
            this.addFeatureNote(featItem, key, value);
        }
    }

    public void addFeatureNote(String key, String value) {
        this.addFeatureNote(this.curFieldItem, key, value);
    }

    public void addFeatureNote(String value) {
        this.addFeatureNote(this.curFieldItem, value);
    }

    public void addFeature(FeatureItem fi) {
        if (fi != null) {
            this.featlist.addElement(fi);
            this.curFieldItem = fi;
        }
    }

    public FeatureItem addFeature(String name, SeqRange sr) {
        this.addFeature(new FeatureItem(name, sr, 4));
        return this.curFieldItem;
    }

    public void addFeatures(FastVector addfeats) {
        FastVector feats = this.features();
        for (int i = 0; i < addfeats.size(); ++i) {
            Object el = addfeats.elementAt(i);
            if (!(el instanceof FeatureItem) || this.findFeature(el) != null) continue;
            el = ((FeatureItem)el).clone();
            feats.addElement((FeatureItem)el);
        }
    }

    public void addFeature(String field, String value, int level, boolean append) {
        if (level == 4 ? !this.keepField(71) : level == 5 && !this.keepField(72)) {
            return;
        }
        if (level == 4) {
            if (append && this.curFieldItem != null) {
                this.curFieldItem.appendValue(value);
            } else {
                this.addFeature(new FeatureItem(field, value, 4));
            }
        } else if (this.curFieldItem != null) {
            if (!value.startsWith("/")) {
                this.curFieldItem.appendNote(value);
            } else {
                this.addFeatureNote(this.curFieldItem, value);
            }
        }
    }

    public void deleteFeature(String name, SeqRange sr) {
        FeatureItem fi = this.findFeature(name, sr);
        if (fi != null) {
            this.features().removeElement(fi);
        }
    }

    public FeatureItem findFeature(String name, SeqRange sr) {
        FastVector feats = this.features();
        int n = feats.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem fi = (FeatureItem)feats.elementAt(i);
            if (!(sr == null ? fi.getName().equals(name) : (name == null ? fi.getLocation().intersects(sr) : fi.getName().equals(name) && fi.getLocation().intersects(sr)))) continue;
            return fi;
        }
        return null;
    }

    public FeatureItem findFeature(String name) {
        FastVector feats = this.features();
        int n = feats.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem fi = (FeatureItem)feats.elementAt(i);
            if (!fi.getName().equals(name)) continue;
            return fi;
        }
        return null;
    }

    public FeatureItem findFeature(Object item) {
        FastVector feats = this.features();
        int n = feats.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem fi = (FeatureItem)feats.elementAt(i);
            if (!fi.equals(item)) continue;
            return fi;
        }
        return null;
    }

    public final FeatureItem[] findFeatures(SeqRange sr) {
        return this.findFeatures((String)null, sr);
    }

    public final FeatureItem[] findFeatures(String name) {
        return this.findFeatures(name, (SeqRange)null);
    }

    public FeatureItem[] findFeatures(String name, SeqRange sr) {
        Vector v = this.findFeatures(name, sr, null);
        Object[] ss = new FeatureItem[v.size()];
        v.copyInto(ss);
        return ss;
    }

    public final Vector findFeatures(SeqRange sr, Vector addto) {
        return this.findFeatures((String)null, sr, addto);
    }

    public final Vector findFeatures(String name, Vector addto) {
        return this.findFeatures(name, null, addto);
    }

    public Vector findFeatures(String name, SeqRange sr, Vector addto) {
        if (addto == null) {
            addto = new Vector<FeatureItem>();
        }
        FastVector feats = this.features();
        int n = feats.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem fi = (FeatureItem)feats.elementAt(i);
            if (sr == null) {
                if (!fi.getName().equals(name)) continue;
                addto.addElement(fi);
                continue;
            }
            if (name != null && !fi.getName().equals(name) || !fi.getLocation().intersects(sr)) continue;
            addto.addElement(fi);
        }
        return addto;
    }

    public Vector findFeatures(Hashtable wantfeatures, SeqRange sr, Vector addto) {
        if (wantfeatures == null) {
            return this.findFeatures(sr, addto);
        }
        if (addto == null) {
            addto = new Vector();
        }
        Vector<FeatureItem> removeto = new Vector<FeatureItem>();
        FastVector feats = this.features();
        int maxloc = 0;
        int n = feats.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem fi = (FeatureItem)feats.elementAt(i);
            String fname = fi.getName();
            SeqRange loc = fi.getLocation();
            maxloc = Math.max(maxloc, loc.stop());
            if (wantfeatures.get(fname) == null || sr != null && !fi.getLocation().intersects(sr)) continue;
            if ("false".equals(wantfeatures.get(fname))) {
                removeto.addElement(fi);
                continue;
            }
            addto.addElement(fi);
        }
        if (!removeto.isEmpty()) {
            SeqRange remsr = new SeqRange();
            int nj = removeto.size();
            for (int j = 0; j < nj; ++j) {
                FeatureItem rfi = (FeatureItem)removeto.elementAt(j);
                SeqRange rsr = rfi.getLocation();
                remsr.add(rsr);
            }
            if (Debug.isOn) {
                Debug.println("findFeatures removeto: " + remsr);
            }
            int seqlen = maxloc + 1;
            if (sr != null) {
                seqlen = 1 + sr.stop();
            }
            SeqRange keepsr = remsr.invert(seqlen);
            if (Debug.isOn) {
                Debug.println("findFeatures keepsr: " + keepsr);
            }
            if (addto.isEmpty()) {
                addto = this.findFeatures(keepsr, addto);
            }
            for (int i = 0; i < addto.size(); ++i) {
                FeatureItem fi = (FeatureItem)addto.elementAt(i);
                SeqRange filoc = fi.getLocation();
                if (!filoc.intersects(remsr)) continue;
                if (Debug.isOn) {
                    Debug.println("findFeatures filoc: " + filoc);
                }
                SeqRange inloc = filoc.intersectparts(keepsr);
                if (Debug.isOn) {
                    Debug.println("findFeatures inloc: " + inloc);
                }
                fi.setValue(inloc.toString());
            }
        }
        return addto;
    }

    public String[] getFeaturesAt(SeqRange sr) {
        Vector<String> v = new Vector<String>();
        FastVector feats = this.features();
        int n = feats.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem fi = (FeatureItem)feats.elementAt(i);
            if (!fi.getLocation().intersects(sr)) continue;
            v.addElement(fi.getName());
        }
        Object[] ss = new String[v.size()];
        v.copyInto(ss);
        return ss;
    }

    public void updateRange(int changeflags, int start, int length, byte[] changes) {
        FastVector feats = this.features();
        int n = feats.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem fi = (FeatureItem)feats.elementAt(i);
            fi.updateRange(changeflags, start, length, changes);
        }
    }

    public final void removeRange(SeqRange sr) {
        for (SeqRange loc = sr; loc != null; loc = loc.next()) {
            this.updateRange(1, loc.start(), loc.nbases(), null);
        }
    }

    public final void insertRange(SeqRange sr) {
        for (SeqRange loc = sr; loc != null; loc = loc.next()) {
            this.updateRange(2, loc.start(), loc.nbases(), null);
        }
    }

    public Hashtable wantedFeatures() {
        return this.wantedFeatures;
    }

    public SeqRange wantedRange() {
        return this.wantedRange;
    }

    public boolean isNotWantedFeature() {
        return this.notWantedFeature;
    }

    protected void copyWanted(BioseqDocImpl src) {
        this.setWantedFeatures(src.wantedFeatures, src.wantedRange);
        this.extractionNote = src.extractionNote;
    }

    public void setWantedFeatures(Hashtable wantfeatures) {
        this.setWantedFeatures(wantfeatures, null);
    }

    public void setWantedFeatures(Hashtable wantfeatures, SeqRange wantedrange) {
        boolean extract = true;
        if (wantfeatures != null) {
            try {
                this.wantExtractionLoc = wantfeatures.size() == 1 && wantfeatures.containsKey(sExtractRangeFeature);
                extract = !"false".equals(wantfeatures.elements().nextElement());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.setWantedFeatures(extract, wantfeatures, wantedrange);
    }

    public void setWantedFeatures(boolean extract, Hashtable wantfeatures, SeqRange wantedrange) {
        this.wantedFeatures = wantfeatures;
        this.wantedRange = wantedrange;
        this.notWantedFeature = !extract;
    }

    public final SeqRange getFeatureRanges(int offset, int seqlen) {
        SeqRange srlist;
        this.wantedRange = srlist = this.getFeatureRanges(this.wantedFeatures, offset, seqlen);
        return srlist;
    }

    public SeqRange getFeatureRanges(Hashtable wantfeatures, int offset, int seqlen) {
        if (wantfeatures == null) {
            return null;
        }
        boolean foundfeat = false;
        FastVector feats = this.features();
        boolean wantExLoc = wantfeatures.size() == 1 && wantfeatures.containsKey(sExtractRangeFeature);
        SeqRange srlist = new SeqRange();
        SeqRange wantedrange = this.wantedRange != null && !this.wantedRange.isEmpty() ? this.wantedRange : new SeqRange(offset, seqlen);
        int n = feats.size();
        for (int i = 0; i < n; ++i) {
            FeatureItem fi = (FeatureItem)feats.elementAt(i);
            String fname = fi.getName();
            if (wantfeatures.get(fname) == null) continue;
            foundfeat = true;
            SeqRange sr = fi.getLocation();
            if (!sr.intersectsMax(wantedrange)) continue;
            if (wantExLoc) {
                srlist = sr;
                break;
            }
            srlist = srlist.joinRange(sr);
        }
        if (this.notWantedFeature) {
            if (foundfeat) {
                srlist = srlist.invert(seqlen);
            } else {
                return null;
            }
        }
        if (Debug.isOn) {
            Debug.println("getFeatureRanges: " + srlist);
        }
        return srlist;
    }

    public int linesWritten() {
        return this.linesout;
    }

    public int getIndent() {
        return this.indent;
    }

    final String spaces(int n) {
        return Fmt.fmt("", n);
    }

    protected String getFieldLabel(DocItem di) {
        return this.getFieldLabel(di.getLevel(), di);
    }

    public String getContinueLabel(DocItem di) {
        switch (di.getLevel()) {
            default: {
                return this.getFieldLabel(3, di);
            }
            case 4: 
            case 5: 
            case 6: 
        }
        return this.getFieldLabel(6, di);
    }

    protected String getFieldLabel(int level, DocItem di) {
        this.indent = 5;
        return Fmt.fmt(di.getName(), this.indent - 1, 2) + " ";
    }

    protected String getFieldValue(DocItem di) {
        char c;
        String val = di.getValue();
        if (val != null && val.length() > 1 && di.getLevel() == 5 && (c = val.charAt(0)) != '\"' && c != '\'' && (c < '0' || c > '9')) {
            val = '\"' + val + '\"';
        }
        return val;
    }

    protected final String getTrimFieldValue(DocItem di) {
        return this.getTrimFieldValue(di.getValue());
    }

    protected String getTrimFieldValue(String val) {
        if (val != null) {
            char c;
            val = val.replace('\n', ' ');
            int len = (val = val.trim()).length();
            if (len > 1 && ((c = val.charAt(0)) == '\"' || c == '\'') && val.charAt(len - 1) == c) {
                val = val.substring(1, len - 1);
            }
        }
        return val;
    }

    public void setOutput(Writer outs) {
        if (outs instanceof PrintWriter) {
            this.pr = (PrintWriter)outs;
        } else {
            BufferedWriter bufout = outs instanceof BufferedWriter ? (BufferedWriter)outs : new BufferedWriter(outs);
            this.pr = new PrintWriter(bufout);
        }
        this.linesout = 0;
        this.indent = 0;
    }

    public void setOutput(OutputStream outs) {
        BufferedOutputStream bufout = outs instanceof BufferedOutputStream ? (BufferedOutputStream)outs : new BufferedOutputStream(outs);
        this.pr = new PrintWriter(bufout);
        this.indent = 0;
        this.linesout = 0;
    }

    public int writeTo(Writer outs) {
        return this.writeTo(outs, false);
    }

    public int writeTo(Writer outs, boolean doId) {
        this.dontWriteId = !doId;
        this.setOutput(outs);
        this.writeAllText();
        return this.linesWritten();
    }

    public int compareTo(Writer outs, BioseqDocImpl otherdoc) {
        int fdiff;
        this.setOutput(outs);
        int ddiff = this.compareDocVectors("Document", this.documents(), otherdoc.documents());
        if (ddiff == 0 && this.documents().size() > 0) {
            this.pr.println("# Document is same for n=" + this.documents().size());
        }
        if ((fdiff = this.compareDocVectors("Features", this.features(), otherdoc.features())) == 0 && this.features().size() > 0) {
            this.pr.println("# Features are same for n=" + this.features().size());
        }
        return this.linesWritten();
    }

    protected int compareDocVectors(String lab, FastVector v, FastVector ov) {
        boolean isdoc;
        int ndiff = 0;
        if (v == null && ov == null) {
            return 0;
        }
        if (v == null || ov == null) {
            return this.diff(lab + " null", String.valueOf(v == null), String.valueOf(ov == null));
        }
        if (v.size() != ov.size()) {
            ndiff += this.diff(lab + " count: ", String.valueOf(v.size()), String.valueOf(ov.size()));
        }
        boolean bl = isdoc = this.documents() == v;
        if (isdoc) {
            int kind = 0;
            int which = 0;
            Enumeration en = biodockinds.keys();
            while (en.hasMoreElements()) {
                Integer key = (Integer)en.nextElement();
                kind = key;
                which = 0;
                boolean more = true;
                while (more) {
                    DocItem mydi = this.findDocItem(v, kind, which);
                    DocItem odi = this.findDocItem(ov, kind, which);
                    boolean bl2 = more = mydi != null && odi != null;
                    if (more) {
                        ndiff += this.compareDocItems("Document", mydi, odi);
                    } else if (mydi == null && odi != null) {
                        lab = BioseqDocImpl.getBiodoclabel(odi.getKind());
                        if (which > 0) {
                            lab = lab + " " + String.valueOf(which + 1);
                        }
                        ndiff += this.compareDocItems(lab, mydi, odi);
                    }
                    ++which;
                }
            }
        } else {
            int n = Math.min(v.size(), ov.size());
            for (int i = 0; i < n; ++i) {
                ndiff += this.compareDocItems(lab, (DocItem)v.elementAt(i), (DocItem)ov.elementAt(i));
            }
        }
        return ndiff;
    }

    protected int compareDocItems(String lab, DocItem v, DocItem ov) {
        int ndiff = 0;
        if (v == null && ov == null) {
            return 0;
        }
        if (v == null || ov == null) {
            String vnv = v == null ? "(missing)" : this.getTrimFieldValue(v);
            String vov = ov == null ? "(missing)" : this.getTrimFieldValue(ov);
            return ndiff += this.diff(lab, vnv, vov);
        }
        boolean isdoc = lab.startsWith("Doc");
        if (!v.equals(ov)) {
            if (isdoc && !v.sameKind(ov)) {
                ndiff += this.diff("kind: ", BioseqDocImpl.getBiodoclabel(v.getKind()), BioseqDocImpl.getBiodoclabel(ov.getKind()));
            }
            if (!isdoc && !v.sameName(ov)) {
                ndiff += this.diff("key: ", v.getName(), ov.getName());
            }
            if (!v.sameValue(ov.getValue())) {
                String vov;
                lab = BioseqDocImpl.getBiodoclabel(v.getKind()) + " value: ";
                String vnv = this.getTrimFieldValue(v);
                if (!vnv.equals(vov = this.getTrimFieldValue(ov))) {
                    ndiff += this.diff(lab, vnv, vov);
                }
            }
        }
        if (v instanceof FeatureItem && ov instanceof FeatureItem) {
            ndiff += this.compareDocVectors("Notes ", ((FeatureItem)v).notes, ((FeatureItem)ov).notes);
        }
        return ndiff;
    }

    protected int diff(String fld, String newval, String oldval) {
        this.pr.print(Fmt.fmt(fld, 15, 2) + " ");
        this.pr.print(Fmt.fmt(newval, 15));
        this.pr.print(" != ");
        this.pr.print(Fmt.fmt(oldval, 15));
        this.pr.println();
        ++this.linesout;
        return 1;
    }

    public void writeAllText() {
        this.featWrit = false;
        this.writeTextTop(this.rootdoc, true);
        if (!this.featWrit && this.features().size() > 0) {
            String fn = this.getFieldName(70);
            this.writeDocItem(new DocItem(fn, "", 70, 1), true);
        }
        this.pr.flush();
    }

    public void writeDocumentText() {
        this.writeTextTop(this.documents(), false);
    }

    public void writeFeatureText() {
        this.writeTextTop(this.features(), false);
    }

    public String getDocumentText() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.setOutput(new PrintWriter(baos));
        this.writeDocumentText();
        this.pr.flush();
        return baos.toString();
    }

    public String getFeatureText() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.setOutput(new PrintWriter(baos));
        this.writeFeatureText();
        this.pr.flush();
        return baos.toString();
    }

    protected void writeTextTop(FastVector v, boolean writeAll) {
        this.writeDocVector(v, writeAll);
    }

    protected void writeDocVector(FastVector v, boolean writeAll) {
        for (int i = 0; i < v.size(); ++i) {
            this.writeDocItem((DocItem)v.elementAt(i), writeAll);
        }
    }

    protected boolean wantFeature(DocItem di) {
        SeqRange sr;
        String name = di.getName();
        if (sExtractRangeFeature.equals(name)) {
            return false;
        }
        if (sExtractionFeature.equals(name)) {
            return true;
        }
        if (this.wantedFeatures == null || this.wantExtractionLoc) {
            return true;
        }
        if (this.wantedRange != null && !this.wantedRange.isEmpty() && di instanceof FeatureItem && !(sr = ((FeatureItem)di).getLocation()).intersectsMax(this.wantedRange)) {
            return false;
        }
        String wantval = (String)this.wantedFeatures.get(name);
        if (wantval == null) {
            return this.notWantedFeature;
        }
        if ("true".equals(wantval)) {
            return true;
        }
        if ("false".equals(wantval)) {
            return false;
        }
        return this.notWantedFeature;
    }

    public void setExtractionNote(String notes) {
        this.extractionNote = notes == null ? sExtractionNote : notes;
    }

    protected void writeExtractionFeature() {
        if (this.wantedFeatures != null && this.wantedRange != null) {
            String dq = this instanceof XmlDoc ? "" : "\"";
            FeatureItem wfi = new FeatureItem(sExtractionFeature, this.wantedRange, 4);
            wfi.putNote(new FeatureNote("/note", dq + this.extractionNote + dq));
            this.writeDocItem(wfi, false);
        }
    }

    protected boolean writeKeyValue(DocItem di) {
        String lab = this.getFieldLabel(di);
        String val = this.getFieldValue(di);
        if (lab != null) {
            if (di instanceof PrintableDocItem) {
                ((PrintableDocItem)((Object)di)).print(this.pr, this, lab, val);
            } else {
                this.pr.print(lab);
                if (di.getLevel() == 5) {
                    this.indent += this.subindent;
                }
                while (val != null) {
                    if ((val = this.writeWrapText(val, this.indent, this.kLinewidth)) == null) continue;
                    String continuelab = this.getContinueLabel(di);
                    this.pr.print(continuelab);
                }
            }
            return true;
        }
        return false;
    }

    protected void adjustFeatureLoc(DocItem nv) {
        if (!this.wantExtractionLoc || nv instanceof FeatureItem) {
            // empty if block
        }
    }

    protected void writeDocItem(DocItem nv, boolean writeAll) {
        switch (nv.getKind()) {
            case 111: {
                return;
            }
            case 10: {
                if (this.dontWriteId) break;
                this.writeKeyValue(nv);
                break;
            }
            case 70: {
                if (this.featWrit || !this.writeKeyValue(nv) || !writeAll) break;
                this.writeDocVector(this.features(), writeAll);
                this.writeExtractionFeature();
                this.featWrit = true;
                break;
            }
            case 71: {
                if (!this.wantFeature(nv) || !this.writeKeyValue(nv) || !(nv instanceof FeatureItem)) break;
                FeatureItem fi = (FeatureItem)nv;
                if (fi.notes == null) break;
                this.writeDocVector(fi.notes, false);
                break;
            }
            case 72: {
                this.writeKeyValue(nv);
                break;
            }
            default: {
                if (!this.wantFeature(nv)) break;
                this.writeKeyValue(nv);
            }
        }
    }

    public String writeWrapText(String val) {
        return this.writeWrapText(val, this.indent, this.kLinewidth);
    }

    protected String writeWrapText(String val, int indent, int width) {
        String rval = null;
        int maxw = width - indent;
        int vlen = val.length();
        int max2 = maxw + 2;
        int at = val.indexOf(10);
        if (at < 0) {
            at = val.indexOf(13);
        }
        if (at >= 0 && at <= max2) {
            if (at < vlen) {
                rval = val.substring(at + 1).trim();
            }
            val = val.substring(0, at);
        } else if (vlen > maxw) {
            at = val.lastIndexOf(32, max2);
            if (at < 0 && (at = val.lastIndexOf(44, max2)) > 0) {
                ++at;
            }
            if (at < 0 && (at = val.lastIndexOf(59, max2)) > 0) {
                ++at;
            }
            if (at < 0 && (at = val.lastIndexOf(46, max2)) > 0) {
                ++at;
            }
            if (at < 0) {
                at = maxw;
            }
            if (at > 10) {
                rval = val.substring(at).trim();
                val = val.substring(0, at);
            }
        }
        this.pr.println(val);
        ++this.linesout;
        return rval;
    }

    static {
        BioseqDocImpl.getBioseqdocProperties();
    }
}

