/*
 * Decompiled with CFR 0.152.
 */
package flybase;

import flybase.Debug;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLConnection;

public class DocFormat {
    protected int format;
    protected String mimetype;
    public static final int TEXT = 1230;
    public static final int DATA = 1231;
    public static final int PICT = 1232;
    public static final int POSTSCRIPT = 1233;
    public static final int JPEG = 1234;
    public static final int GIF = 1235;
    public static final int HTML = 1236;
    public static final int PRINTJOB = 1237;
    public static final int PDF = 1238;

    public DocFormat() {
    }

    public DocFormat(int format) {
        this.format = format;
        this.mimetype = this.mycontentType(format);
    }

    public DocFormat(String mimetype) {
        this.mimetype = mimetype;
        this.format = this.myformatFromContentType(mimetype);
    }

    public DocFormat(File f) {
        this.mimetype = DocFormat.guessContentType(f);
        this.format = this.myformatFromContentType(this.mimetype);
    }

    public DocFormat(InputStream ins) {
        this.mimetype = DocFormat.guessContentType(ins);
        this.format = this.myformatFromContentType(this.mimetype);
    }

    public int format() {
        return this.format;
    }

    public String contentType() {
        if (this.mimetype == null) {
            this.mimetype = this.mycontentType(this.format);
        }
        return this.mimetype;
    }

    public String mycontentType(int format) {
        return DocFormat.contentType(format);
    }

    public static String contentType(int format) {
        switch (format) {
            case 1230: {
                return "text/plain";
            }
            case 1236: {
                return "text/html";
            }
            case 1231: {
                return "*/*";
            }
            case 1232: {
                return "image/pict";
            }
            case 1238: {
                return "application/pdf";
            }
            case 1233: {
                return "application/postscript";
            }
            case 1234: {
                return "image/jpeg";
            }
            case 1235: {
                return "image/gif";
            }
            case 1237: {
                return "application/printer";
            }
        }
        return "*/*";
    }

    public int myformatFromContentType(String mime) {
        return DocFormat.formatFromContentType(mime);
    }

    public static int formatFromContentType(String mime) {
        if (mime == null || mime.length() == 0) {
            return 0;
        }
        if ((mime = mime.toLowerCase()).equals("application/printer")) {
            return 1237;
        }
        if (mime.startsWith("text/html")) {
            return 1236;
        }
        if (mime.startsWith("text")) {
            return 1230;
        }
        if (mime.endsWith("pict")) {
            return 1232;
        }
        if (mime.endsWith("jpeg")) {
            return 1234;
        }
        if (mime.endsWith("jpg")) {
            return 1234;
        }
        if (mime.endsWith("gif")) {
            return 1235;
        }
        if (mime.endsWith("pdf")) {
            return 1238;
        }
        if (mime.endsWith("postscript")) {
            return 1233;
        }
        if (mime.endsWith("/ps")) {
            return 1233;
        }
        if (mime.endsWith("printer")) {
            return 1237;
        }
        return 0;
    }

    public static int formatFromSuffix(String suf) {
        if (suf == null || suf.length() == 0) {
            return 0;
        }
        if ((suf = suf.toLowerCase()).endsWith("html")) {
            return 1236;
        }
        if (suf.endsWith("text")) {
            return 1230;
        }
        if (suf.endsWith("txt")) {
            return 1230;
        }
        if (suf.endsWith("pict")) {
            return 1232;
        }
        if (suf.endsWith("jpeg")) {
            return 1234;
        }
        if (suf.endsWith("jpg")) {
            return 1234;
        }
        if (suf.endsWith("gif")) {
            return 1235;
        }
        if (suf.endsWith("pdf")) {
            return 1238;
        }
        if (suf.endsWith("postscript")) {
            return 1233;
        }
        if (suf.endsWith("ps")) {
            return 1233;
        }
        return 0;
    }

    public String suffix() {
        return this.mysuffix(this.format);
    }

    public String mysuffix(int format) {
        return DocFormat.suffix(format);
    }

    public static String suffix(int format) {
        switch (format) {
            case 1230: {
                return ".txt";
            }
            case 1236: {
                return ".html";
            }
            case 1231: {
                return ".data";
            }
            case 1232: {
                return ".pict";
            }
            case 1238: {
                return ".pdf";
            }
            case 1233: {
                return ".ps";
            }
            case 1234: {
                return ".jpeg";
            }
            case 1235: {
                return ".gif";
            }
        }
        return "";
    }

    public String macType() {
        return this.mymacType(this.format);
    }

    public String mymacType(int format) {
        return DocFormat.macType(format);
    }

    public static String macType(int format) {
        switch (format) {
            case 1230: {
                return "TEXT";
            }
            case 1236: {
                return "TEXT";
            }
            case 1232: {
                return "PICT";
            }
            case 1238: {
                return "PDF ";
            }
            case 1233: {
                return "POST";
            }
            case 1234: {
                return "JPEG";
            }
            case 1235: {
                return "GIFf";
            }
        }
        return null;
    }

    public String macSire() {
        return this.mymacSire(this.format);
    }

    public String mymacSire(int format) {
        return DocFormat.macSire(format);
    }

    public static String macSire(int format) {
        switch (format) {
            case 1230: {
                return "R*ch";
            }
            case 1236: {
                return "MOSS";
            }
            case 1232: {
                return "ttxt";
            }
            case 1238: {
                return "CARO";
            }
            case 1233: {
                return "????";
            }
            case 1234: {
                return "JVWR";
            }
            case 1235: {
                return "JVWR";
            }
        }
        return null;
    }

    public String myguessContentType(File f) {
        String mimetype = "*/*";
        try {
            FileInputStream ins = new FileInputStream(f);
            mimetype = this.myguessContentType(ins);
            ins.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mimetype;
    }

    public static String guessContentType(File f) {
        String mimetype = "*/*";
        try {
            FileInputStream ins = new FileInputStream(f);
            mimetype = DocFormat.guessContentType(ins);
            ins.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mimetype;
    }

    public String myguessContentType(InputStream ins) {
        return DocFormat.guessContentType(ins);
    }

    public static String guessContentType(InputStream ins) {
        String mimetype = "*/*";
        try {
            if (!(ins instanceof BufferedInputStream)) {
                ins = new BufferedInputStream(ins);
            }
            mimetype = URLConnection.guessContentTypeFromStream(ins);
            Debug.println(" guessContentType =" + mimetype);
        }
        catch (Exception e) {
            Debug.println(" guessContentType failed: " + e.getMessage());
        }
        return mimetype;
    }
}

