/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.internal.CMException;

class CMStateSet {
    int fBitCount;
    int fByteCount;
    int fBits1;
    int fBits2;
    byte[] fByteArray;

    CMStateSet(int bitCount) throws CMException {
        this.fBitCount = bitCount;
        if (this.fBitCount < 0) {
            throw new CMException(156);
        }
        if (this.fBitCount > 64) {
            this.fByteCount = this.fBitCount / 8;
            if (this.fBitCount % 8 != 0) {
                ++this.fByteCount;
            }
            this.fByteArray = new byte[this.fByteCount];
        }
        this.zeroBits();
    }

    public String toString() {
        StringBuffer strRet = new StringBuffer();
        try {
            strRet.append("{");
            int index = 0;
            while (index < this.fBitCount) {
                if (this.getBit(index)) {
                    strRet.append(" " + index);
                }
                ++index;
            }
            strRet.append(" }");
        }
        catch (CMException cMException) {}
        return strRet.toString();
    }

    final void intersection(CMStateSet setToAnd) {
        if (this.fBitCount < 65) {
            this.fBits1 &= setToAnd.fBits1;
            this.fBits2 &= setToAnd.fBits2;
            return;
        }
        int index = this.fByteCount - 1;
        while (index >= 0) {
            int n = index;
            this.fByteArray[n] = (byte)(this.fByteArray[n] & setToAnd.fByteArray[index]);
            --index;
        }
    }

    final boolean getBit(int bitToGet) throws CMException {
        if (bitToGet >= this.fBitCount) {
            throw new CMException(156);
        }
        if (this.fBitCount < 65) {
            int mask = 1 << bitToGet % 32;
            if (bitToGet < 32) {
                return (this.fBits1 & mask) != 0;
            }
            return (this.fBits2 & mask) != 0;
        }
        int ofs = bitToGet >> 3;
        byte mask = (byte)(1 << bitToGet % 8);
        return (this.fByteArray[ofs] & mask) != 0;
    }

    final boolean isEmpty() {
        if (this.fBitCount < 65) {
            return this.fBits1 == 0 && this.fBits2 == 0;
        }
        int index = this.fByteCount - 1;
        while (index >= 0) {
            if (this.fByteArray[index] != 0) {
                return false;
            }
            --index;
        }
        return true;
    }

    final boolean isSameSet(CMStateSet setToCompare) {
        if (this.fBitCount != setToCompare.fBitCount) {
            return false;
        }
        if (this.fBitCount < 65) {
            return this.fBits1 == setToCompare.fBits1 && this.fBits2 == setToCompare.fBits2;
        }
        int index = this.fByteCount - 1;
        while (index >= 0) {
            if (this.fByteArray[index] != setToCompare.fByteArray[index]) {
                return false;
            }
            --index;
        }
        return true;
    }

    final void union(CMStateSet setToOr) {
        if (this.fBitCount < 65) {
            this.fBits1 |= setToOr.fBits1;
            this.fBits2 |= setToOr.fBits2;
            return;
        }
        int index = this.fByteCount - 1;
        while (index >= 0) {
            int n = index;
            this.fByteArray[n] = (byte)(this.fByteArray[n] | setToOr.fByteArray[index]);
            --index;
        }
    }

    final void setBit(int bitToSet) throws CMException {
        int ofs;
        if (bitToSet >= this.fBitCount) {
            throw new CMException(156);
        }
        if (this.fBitCount < 65) {
            int mask = 1 << bitToSet % 32;
            if (bitToSet < 32) {
                this.fBits1 &= ~mask;
                this.fBits1 |= mask;
                return;
            }
            this.fBits2 &= ~mask;
            this.fBits2 |= mask;
            return;
        }
        byte mask = (byte)(1 << bitToSet % 8);
        int n = ofs = bitToSet >> 3;
        this.fByteArray[n] = (byte)(this.fByteArray[n] & ~mask);
        int n2 = ofs;
        this.fByteArray[n2] = (byte)(this.fByteArray[n2] | mask);
    }

    final void setTo(CMStateSet srcSet) throws CMException {
        if (this.fBitCount != srcSet.fBitCount) {
            throw new CMException(156);
        }
        if (this.fBitCount < 65) {
            this.fBits1 = srcSet.fBits1;
            this.fBits2 = srcSet.fBits2;
            return;
        }
        int index = this.fByteCount - 1;
        while (index >= 0) {
            this.fByteArray[index] = srcSet.fByteArray[index];
            --index;
        }
    }

    final void zeroBits() {
        if (this.fBitCount < 65) {
            this.fBits1 = 0;
            this.fBits2 = 0;
            return;
        }
        int index = this.fByteCount - 1;
        while (index >= 0) {
            this.fByteArray[index] = 0;
            --index;
        }
    }
}

