/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DocumentImpl;
import com.ibm.xml.dom.NamedNodeMapImpl;
import com.ibm.xml.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocumentTypeImpl
extends NodeImpl
implements DocumentType {
    protected NamedNodeMapImpl entities;
    protected NamedNodeMapImpl notations;
    protected NamedNodeMapImpl elements;
    protected boolean syncInfo;

    DocumentTypeImpl(DocumentImpl ownerDocument, int nodeIndex) {
        super(ownerDocument, nodeIndex);
        this.syncChildren = false;
        this.syncInfo = true;
    }

    public DocumentTypeImpl(DocumentImpl ownerDocument, String name) {
        super(ownerDocument, name, null);
        this.entities = new NamedNodeMapImpl(ownerDocument, null);
        this.notations = new NamedNodeMapImpl(ownerDocument, null);
        this.elements = new NamedNodeMapImpl(ownerDocument, null);
    }

    public short getNodeType() {
        return 10;
    }

    public void setNodeValue(String value) throws DOMException {
        throw new DOMExceptionImpl(7, null);
    }

    public Node cloneNode(boolean deep) {
        DocumentTypeImpl newnode = (DocumentTypeImpl)super.cloneNode(deep);
        newnode.entities = this.entities.cloneMap();
        newnode.notations = this.notations.cloneMap();
        newnode.elements = this.elements.cloneMap();
        return newnode;
    }

    public String getName() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.name;
    }

    public NamedNodeMap getEntities() {
        if (this.syncInfo) {
            this.synchronizeInfo();
        }
        return this.entities;
    }

    public NamedNodeMap getNotations() {
        if (this.syncInfo) {
            this.synchronizeInfo();
        }
        return this.notations;
    }

    public void setReadOnly(boolean readOnly, boolean deep) {
        if (this.syncInfo) {
            this.synchronizeInfo();
        }
        this.setReadOnly(readOnly, deep);
        this.elements.setReadOnly(readOnly, true);
        this.entities.setReadOnly(readOnly, true);
        this.notations.setReadOnly(readOnly, true);
    }

    public NamedNodeMap getElements() {
        if (this.syncInfo) {
            this.synchronizeInfo();
        }
        return this.elements;
    }

    protected void synchronizeInfo() {
        this.entities = new NamedNodeMapImpl(this.ownerDocument, null);
        this.notations = new NamedNodeMapImpl(this.ownerDocument, null);
        this.elements = new NamedNodeMapImpl(this.ownerDocument, null);
        int index = this.ownerDocument.getFirstChild(this.fNodeIndex);
        while (index != -1) {
            NodeImpl node = this.ownerDocument.getNodeObject(index);
            short type = node.getNodeType();
            switch (type) {
                case 6: {
                    this.entities.setNamedItem(node);
                    break;
                }
                case 12: {
                    this.notations.setNamedItem(node);
                    break;
                }
                case -1: {
                    this.elements.setNamedItem(node);
                    NamedNodeMap attrs = node.getAttributes();
                    int attrIndex = this.ownerDocument.getFirstChild(node.fNodeIndex);
                    while (attrIndex != -1) {
                        NodeImpl attr = this.ownerDocument.getNodeObject(attrIndex);
                        attrs.setNamedItem(attr);
                        attrIndex = this.ownerDocument.getNextSibling(attrIndex);
                    }
                    break;
                }
                default: {
                    System.out.println("DocumentTypeImpl#synchronizeInfo: node.getNodeType() = " + node.getNodeType() + ", class = " + node.getClass().getName());
                }
            }
            index = this.ownerDocument.getNextSibling(index);
        }
        this.syncInfo = false;
    }
}

