/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.ElementImpl;
import com.ibm.xml.dom.NodeImpl;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeepNodeListImpl
implements NodeList {
    protected NodeImpl rootNode;
    protected String tagName;
    protected int changes = 0;
    protected Vector nodes;

    protected DeepNodeListImpl(NodeImpl rootNode, String tagName) {
        this.rootNode = rootNode;
        this.tagName = tagName;
        this.nodes = new Vector();
    }

    public int getLength() {
        this.item(Integer.MAX_VALUE);
        return this.nodes.size();
    }

    public Node item(int index) {
        if (this.rootNode.changes != this.changes) {
            this.nodes = new Vector();
            this.changes = this.rootNode.changes;
        }
        if (index < this.nodes.size()) {
            return (Node)this.nodes.elementAt(index);
        }
        Node thisNode = this.nodes.size() == 0 ? this.rootNode : (NodeImpl)this.nodes.lastElement();
        while (thisNode != null && index >= this.nodes.size()) {
            if ((thisNode = this.nextMatchingElementAfter(thisNode)) == null) continue;
            this.nodes.addElement(thisNode);
        }
        return thisNode;
    }

    private Node nextMatchingElementAfter(Node current) {
        while (current != null) {
            Node next;
            if (current.hasChildNodes()) {
                current = current.getFirstChild();
            } else if (current != this.rootNode && (next = current.getNextSibling()) != null) {
                current = next;
            } else {
                next = null;
                while (current != this.rootNode) {
                    next = current.getNextSibling();
                    if (next != null) break;
                    current = current.getParentNode();
                }
                current = next;
            }
            if (current == this.rootNode || current == null || current.getNodeType() != 1 || !this.tagName.equals("*") && !((ElementImpl)current).getTagName().equals(this.tagName)) continue;
            return current;
        }
        return null;
    }
}

