/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dom;

import com.ibm.xml.dom.DOMExceptionImpl;
import com.ibm.xml.dom.DocumentImpl;
import com.ibm.xml.dom.NodeImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class CharacterDataImpl
extends NodeImpl
implements CharacterData {
    CharacterDataImpl(DocumentImpl ownerDocument, int nodeIndex) {
        super(ownerDocument, nodeIndex);
    }

    protected CharacterDataImpl(DocumentImpl ownerDocument, String data) {
        super(ownerDocument, null, data);
    }

    public abstract String getNodeName();

    public String getData() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.value;
    }

    public int getLength() {
        if (this.syncData) {
            this.synchronizeData();
        }
        return this.value.length();
    }

    public void appendData(String data) {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        this.value = String.valueOf(this.value) + data;
    }

    public void deleteData(int offset, int count) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (count < 0) {
            throw new DOMExceptionImpl(1, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        int tailLength = Math.max(this.value.length() - count - offset, 0);
        try {
            this.value = String.valueOf(this.value.substring(0, offset)) + (tailLength > 0 ? this.value.substring(offset + count, offset + count + tailLength) : "");
            return;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, null);
        }
    }

    public void insertData(int offset, String data) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, null);
        }
        if (this.syncData) {
            this.synchronizeData();
        }
        try {
            this.value = new StringBuffer(this.value).insert(offset, data).toString();
            return;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, null);
        }
    }

    public void replaceData(int offset, int count, String data) throws DOMException {
        this.deleteData(offset, count);
        this.insertData(offset, data);
    }

    public void setData(String value) throws DOMException {
        this.setNodeValue(value);
    }

    public String substringData(int offset, int count) throws DOMException {
        if (this.syncData) {
            this.synchronizeData();
        }
        int length = this.value.length();
        if (count < 0 || offset < 0 || offset > length - 1) {
            throw new DOMExceptionImpl(1, null);
        }
        int tailIndex = Math.min(offset + count, length);
        return this.value.substring(offset, tailIndex);
    }
}

