/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class FetchFromEntrez {
    static boolean useStdout = false;
    static boolean useBatchEntrez = false;
    static boolean useSingleBatch = true;
    public static String entrezUrl = "http://www.ncbi.nlm.nih.gov/htbin-post/Entrez/query?form=6";
    public static String entrezBatchUrl = "http://www.ncbi.nlm.nih.gov/cgi-bin/Entrez/nph-batch/result";
    public static String usage = "This java program extracts dna or protein sequences using gid numbers.\nfrom a perl script by Bill Pearson, converted to java by d. gilbert\n\nUsage:  java FetchFromEntrez [options] gid gid gid ...\noptions:\n -               - write to standard output\n output=somefile - output filename\n single|batch    - do single or batch request\n dna|protein     - choose dna or protein output\n html|text       - html or plain text\n fasta|genbank   - sequence format\n";
    static String mimebound = "-----------------------------241862694713319";

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(usage);
        } else {
            boolean html = false;
            String db = "n";
            String form = "f";
            String outname = "entrez_fetch";
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    useStdout = true;
                    args[i] = null;
                    continue;
                }
                if (args[i].startsWith("output=")) {
                    outname = args[i].substring(7);
                    args[i] = null;
                    continue;
                }
                if (args[i].startsWith("dna")) {
                    db = "n";
                    args[i] = null;
                    continue;
                }
                if (args[i].startsWith("prot")) {
                    db = "p";
                    args[i] = null;
                    continue;
                }
                if (args[i].startsWith("fasta")) {
                    form = "f";
                    args[i] = null;
                    continue;
                }
                if (args[i].startsWith("genbank")) {
                    form = "g";
                    args[i] = null;
                    continue;
                }
                if (args[i].startsWith("html")) {
                    html = true;
                    args[i] = null;
                    continue;
                }
                if (args[i].startsWith("text")) {
                    html = false;
                    args[i] = null;
                    continue;
                }
                if (args[i].startsWith("batch")) {
                    useSingleBatch = true;
                    args[i] = null;
                    continue;
                }
                if (args[i].startsWith("single")) {
                    useSingleBatch = false;
                    args[i] = null;
                    continue;
                }
                if (!args[i].startsWith("testbatch")) continue;
                useBatchEntrez = true;
                args[i] = null;
            }
            if (html) {
                outname = outname + ".html";
            }
            if (useBatchEntrez) {
                FetchFromEntrez.batchEntrez(args, outname, html, db, form);
            } else {
                FetchFromEntrez.singleEntrez(args, outname, html, db, form);
            }
        }
    }

    static PrintStream openout(String outname) {
        if (useStdout) {
            return System.out;
        }
        try {
            return new PrintStream(new FileOutputStream(outname, true));
        }
        catch (IOException e) {
            System.err.println("Can't write to " + outname + ", err=" + e.getMessage());
            System.exit(1);
            return null;
        }
    }

    static void singleEntrez(String[] args, String outname, boolean html, String db, String form) {
        String url = entrezUrl + (html ? "" : "&html=no") + "&db=" + db + "&Dopt=" + form + "&uid=";
        String startKey = null;
        if (!html) {
            String string = startKey = form.equals("f") ? ">" : "LOCUS";
        }
        if (useSingleBatch) {
            String gids = "";
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                gids = gids + args[i].replace('_', '|') + ",";
            }
            FetchFromEntrez.callEntrez(url, gids, FetchFromEntrez.openout(outname), startKey);
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                String gid = args[i];
                gid = gid.replace('_', '|');
                outname = args[i].toLowerCase();
                FetchFromEntrez.callEntrez(url, gid, FetchFromEntrez.openout(outname), startKey);
            }
        }
    }

    static void callEntrez(String url, String gid, PrintStream pr, String startKey) {
        boolean haveStart = startKey == null;
        try {
            String s;
            DataInputStream din = new DataInputStream(new URL(url + gid).openStream());
            while ((s = din.readLine()) != null) {
                if (s.startsWith("ERROR") || s.startsWith("*** No Documents Found")) {
                    System.err.println("ERROR - " + gid + " not found: " + s);
                    break;
                }
                if (startKey != null && s.startsWith(startKey)) {
                    haveStart = true;
                }
                if (!haveStart) continue;
                pr.println(s);
            }
            pr.close();
        }
        catch (Exception e) {
            System.err.println("Error reading from " + url + gid);
        }
    }

    static void batchEntrez(String[] args, String outname, boolean html, String db, String form) {
        try {
            HttpURLConnection.setFollowRedirects(true);
            URLConnection hconn = new URL(entrezBatchUrl).openConnection();
            if (hconn instanceof HttpURLConnection) {
                ((HttpURLConnection)hconn).setRequestMethod("POST");
            }
            hconn.setRequestProperty("Content-type", "multipart/form-data;boundary=" + mimebound);
            hconn.setDoOutput(true);
            hconn.setDoInput(true);
            PrintStream pr = new PrintStream(hconn.getOutputStream());
            FetchFromEntrez.printfield(pr, "SEQ_TYPE", db.equals("n") ? "Nucleotide" : "Protein");
            FetchFromEntrez.printfield(pr, "DUMP_TYPE", "FILE");
            FetchFromEntrez.printfield(pr, "FORMAT", form.equals("f") ? "FASTA" : "GenBank/GenPept");
            FetchFromEntrez.printfield(pr, "HTML", html ? "HTML" : "");
            FetchFromEntrez.printfield(pr, "ORGNAME", "");
            FetchFromEntrez.printfield(pr, "LIST_ORG", "(None)");
            FetchFromEntrez.printfield(pr, "REQUEST_TYPE", "FILESUBMIT");
            FetchFromEntrez.printfield(pr, "USERFILE", null, "args");
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                pr.println(args[i].replace('_', '|'));
            }
            FetchFromEntrez.printfieldend(pr);
            pr.close();
            DataInputStream din = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(50L);
                    try {
                        din = new DataInputStream(hconn.getInputStream());
                        break;
                    }
                    catch (IOException e) {
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (hconn instanceof HttpURLConnection) {
                System.err.println("Server msg: " + ((HttpURLConnection)hconn).getResponseMessage());
            }
            if (din != null) {
                String s;
                pr = FetchFromEntrez.openout(outname);
                while ((s = din.readLine()) != null) {
                    pr.println(s);
                }
                pr.close();
            }
        }
        catch (Exception e) {
            System.err.println("Error getting data from " + entrezBatchUrl);
            e.printStackTrace();
        }
    }

    static void printfieldend(PrintStream pr) {
        pr.println(mimebound + "--");
    }

    static final void printfield(PrintStream pr, String name, String value) {
        FetchFromEntrez.printfield(pr, name, value, null);
    }

    static void printfield(PrintStream pr, String name, String value, String fname) {
        pr.println(mimebound);
        pr.print("Content-Disposition: form-data; name=\"" + name + "\"");
        if (fname != null) {
            pr.print("; filename=\"" + fname + "\"");
        }
        pr.println();
        pr.println();
        if (value != null) {
            pr.println(value);
        }
    }
}

